/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import com.google.common.base.Joiner;
import io.prometheus.client.Collector;
import java.util.Map;
import java.util.TreeMap;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.stats.prometheus.ScopeContext;
import org.apache.bookkeeper.stats.prometheus.SimpleGauge;
import org.apache.bookkeeper.stats.prometheus.ThreadScopedDataSketchesStatsLogger;
import org.apache.bookkeeper.stats.prometheus.ThreadScopedLongAdderCounter;

public class PrometheusStatsLogger
implements StatsLogger {
    private final PrometheusMetricsProvider provider;
    private final String scope;
    private final Map<String, String> labels;

    PrometheusStatsLogger(PrometheusMetricsProvider provider, String scope, Map<String, String> labels) {
        this.provider = provider;
        this.scope = scope;
        this.labels = labels;
    }

    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.scopeContext(name), x -> new DataSketchesOpStatsLogger(this.labels));
    }

    public OpStatsLogger getThreadScopedOpStatsLogger(String name) {
        return this.provider.threadScopedOpStats.computeIfAbsent(this.scopeContext(name), x -> new ThreadScopedDataSketchesStatsLogger(this.provider, (ScopeContext)x, this.labels));
    }

    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.scopeContext(name), x -> new LongAdderCounter(this.labels));
    }

    public Counter getThreadScopedCounter(String name) {
        return this.provider.threadScopedCounters.computeIfAbsent(this.scopeContext(name), x -> new ThreadScopedLongAdderCounter(this.provider, (ScopeContext)x, this.labels));
    }

    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.gauges.computeIfAbsent(this.scopeContext(name), x -> new SimpleGauge(gauge, this.labels));
    }

    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }

    public StatsLogger scope(String name) {
        return new PrometheusStatsLogger(this.provider, this.completeName(name), this.labels);
    }

    public StatsLogger scopeLabel(String labelName, String labelValue) {
        TreeMap<String, String> newLabels = new TreeMap<String, String>(this.labels);
        newLabels.put(labelName, labelValue);
        return new PrometheusStatsLogger(this.provider, this.scope, newLabels);
    }

    private ScopeContext scopeContext(String name) {
        return new ScopeContext(this.completeName(name), this.labels);
    }

    private String completeName(String name) {
        return Collector.sanitizeMetricName((String)(this.scope.isEmpty() ? name : Joiner.on((char)'_').join((Object)this.scope, (Object)name, new Object[0])));
    }
}

