/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.storage.StorageContainerStoreBuilder;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageService
extends AbstractLifecycleComponent<StorageConfiguration>
implements Supplier<StorageContainerStore> {
    private static final Logger log = LoggerFactory.getLogger(StorageService.class);
    private final StorageContainerStoreBuilder storeBuilder;
    private StorageContainerStore store;

    public StorageService(StorageConfiguration conf, StorageContainerStoreBuilder storeBuilder, StatsLogger statsLogger) {
        super("storage-service", (ComponentConfiguration)conf, statsLogger);
        this.storeBuilder = storeBuilder;
    }

    protected void doStart() {
        this.store = this.storeBuilder.build();
        this.store.start();
    }

    protected void doStop() {
        this.store.stop();
    }

    protected void doClose() throws IOException {
        if (null != this.store) {
            this.store.close();
        }
    }

    @Override
    public StorageContainerStore get() {
        return this.store;
    }
}

