/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ThrottlingMode;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="throttle")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"expression", "correlationExpression"})
public class ThrottleDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<ThrottleDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.model.ThrottlingMode", defaultValue="TotalRequests", enums="TotalRequests,ConcurrentRequests")
    private String mode;
    @XmlElement(name="correlationExpression")
    private ExpressionSubElementDefinition correlationExpression;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String asyncDelayed;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String callerRunsWhenRejected;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String rejectExecution;
    @XmlAttribute
    @Metadata(defaultValue="1000", javaType="java.time.Duration")
    private String timePeriodMillis;

    public ThrottleDefinition() {
        this.totalRequestsMode();
    }

    protected ThrottleDefinition(ThrottleDefinition source) {
        super(source);
        this.executorServiceBean = source.executorServiceBean;
        this.mode = source.mode;
        this.correlationExpression = source.correlationExpression != null ? source.correlationExpression.copyDefinition() : null;
        this.executorService = source.executorService;
        this.asyncDelayed = source.asyncDelayed;
        this.callerRunsWhenRejected = source.callerRunsWhenRejected;
        this.rejectExecution = source.rejectExecution;
        this.timePeriodMillis = source.timePeriodMillis;
    }

    public ThrottleDefinition(Expression maximumRequestsPerPeriod) {
        super(maximumRequestsPerPeriod);
        this.totalRequestsMode();
    }

    public ThrottleDefinition(Expression maximumRequestsPerPeriod, Expression correlationExpression) {
        this(ExpressionNodeHelper.toExpressionDefinition(maximumRequestsPerPeriod), correlationExpression);
    }

    private ThrottleDefinition(ExpressionDefinition maximumRequestsPerPeriod, Expression correlationExpression) {
        super(maximumRequestsPerPeriod);
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
        this.totalRequestsMode();
    }

    @Override
    public ThrottleDefinition copyDefinition() {
        return new ThrottleDefinition(this);
    }

    public ThrottleDefinition totalRequestsMode() {
        this.mode = ThrottlingMode.TotalRequests.name();
        return this;
    }

    public ThrottleDefinition concurrentRequestsMode() {
        this.mode = ThrottlingMode.ConcurrentRequests.name();
        return this;
    }

    public String toString() {
        return "Throttle[" + this.description() + "]";
    }

    protected String description() {
        if (this.mode.equals(ThrottlingMode.TotalRequests.name())) {
            return String.valueOf(this.getExpression()) + " request per " + this.getTimePeriodMillis() + " millis";
        }
        return String.valueOf(this.getExpression()) + " maximum concurrent requests";
    }

    public String getShortName() {
        return "throttle";
    }

    @Override
    public String getLabel() {
        return "throttle[" + this.description() + "]";
    }

    public ThrottleDefinition timePeriodMillis(long timePeriodMillis) {
        return this.timePeriodMillis(Long.toString(timePeriodMillis));
    }

    public ThrottleDefinition timePeriodMillis(String timePeriodMillis) {
        this.setTimePeriodMillis(timePeriodMillis);
        return this;
    }

    public ThrottleDefinition maximumRequests(long maximumConcurrentRequests) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)maximumConcurrentRequests)));
        return this;
    }

    public ThrottleDefinition maximumRequests(String maximumConcurrentRequests) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)maximumConcurrentRequests)));
        return this;
    }

    @Deprecated(since="4.4.0")
    public ThrottleDefinition maximumRequestsPerPeriod(long maximumRequestsPerPeriod) {
        if (ThrottlingMode.toMode(this.mode) == ThrottlingMode.TotalRequests) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression((Object)maximumRequestsPerPeriod)));
            return this;
        }
        throw new IllegalArgumentException("Maximum requests per period can only be set when using total requests mode");
    }

    @Deprecated(since="4.4.0")
    public ThrottleDefinition maximumRequestsPerPeriod(String maximumRequestsPerPeriod) {
        if (ThrottlingMode.toMode(this.mode) == ThrottlingMode.TotalRequests) {
            this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.simpleExpression((String)maximumRequestsPerPeriod)));
            return this;
        }
        throw new IllegalArgumentException("Maximum requests per period can only be set when using total requests mode");
    }

    public ThrottleDefinition correlationExpression(long correlationExpression) {
        return this.correlationExpression(ExpressionBuilder.constantExpression((Object)correlationExpression));
    }

    public ThrottleDefinition correlationExpression(Expression correlationExpression) {
        ExpressionSubElementDefinition cor = new ExpressionSubElementDefinition();
        cor.setExpressionType(ExpressionNodeHelper.toExpressionDefinition(correlationExpression));
        this.setCorrelationExpression(cor);
        return this;
    }

    public ThrottleDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        return this.callerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
    }

    public ThrottleDefinition callerRunsWhenRejected(String callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThrottleDefinition asyncDelayed() {
        return this.asyncDelayed(true);
    }

    public ThrottleDefinition asyncDelayed(boolean asyncDelayed) {
        return this.asyncDelayed(Boolean.toString(asyncDelayed));
    }

    public ThrottleDefinition asyncDelayed(String asyncDelayed) {
        this.setAsyncDelayed(asyncDelayed);
        return this;
    }

    public ThrottleDefinition rejectExecution(boolean rejectExecution) {
        return this.rejectExecution(Boolean.toString(rejectExecution));
    }

    public ThrottleDefinition rejectExecution(String rejectExecution) {
        this.setRejectExecution(rejectExecution);
        return this;
    }

    @Override
    public ThrottleDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public ThrottleDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public ThrottleDefinition mode(String mode) {
        this.setMode(mode);
        return this;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getTimePeriodMillis() {
        if (ThrottlingMode.toMode(this.mode) == ThrottlingMode.TotalRequests) {
            return this.timePeriodMillis;
        }
        throw new IllegalArgumentException("Time period in millis can only be obtained when using total requests mode");
    }

    public void setTimePeriodMillis(String timePeriodMillis) {
        if (ThrottlingMode.toMode(this.mode) != ThrottlingMode.TotalRequests) {
            throw new IllegalArgumentException("Time period in millis can only be set when using total requests mode");
        }
        this.timePeriodMillis = timePeriodMillis;
    }

    public String getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(String asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public String getRejectExecution() {
        return this.rejectExecution;
    }

    public void setRejectExecution(String rejectExecution) {
        this.rejectExecution = rejectExecution;
    }

    public void setCorrelationExpression(ExpressionSubElementDefinition correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public ExpressionSubElementDefinition getCorrelationExpression() {
        return this.correlationExpression;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }
}

