/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.request;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.config.ProcessingParameters;
import org.jolokia.request.JmxExecRequest;
import org.jolokia.request.JmxListRequest;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.JmxSearchRequest;
import org.jolokia.request.JmxVersionRequest;
import org.jolokia.request.JmxWriteRequest;
import org.jolokia.request.RequestCreator;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.RequestType;

public final class JmxRequestFactory {
    private static final Map<RequestType, RequestCreator> CREATOR_MAP = new HashMap<RequestType, RequestCreator>();

    private JmxRequestFactory() {
    }

    public static <R extends JmxRequest> R createGetRequest(String pPathInfo, ProcessingParameters pProcessingParameters) {
        RequestType type = null;
        try {
            String pathInfo = JmxRequestFactory.extractPathInfo(pPathInfo, pProcessingParameters);
            Stack<String> elements = EscapeUtil.extractElementsFromPath(pathInfo);
            type = elements.size() != 0 ? RequestType.getTypeByName(elements.pop()) : RequestType.VERSION;
            return JmxRequestFactory.getCreator(type).create(elements, pProcessingParameters);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
        catch (EmptyStackException exp) {
            throw new IllegalArgumentException("Invalid arguments in pathinfo " + pPathInfo + (type != null ? " for command " + (Object)((Object)type) : ""), exp);
        }
    }

    public static <R extends JmxRequest> R createPostRequest(Map<String, ?> pRequestMap, ProcessingParameters pProcessingParams) {
        try {
            ProcessingParameters paramsMerged = pProcessingParams.mergedParams((Map)pRequestMap.get("config"));
            RequestType type = RequestType.getTypeByName((String)pRequestMap.get("type"));
            return JmxRequestFactory.getCreator(type).create(pRequestMap, paramsMerged);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
    }

    public static List<JmxRequest> createPostRequests(List pJsonRequests, ProcessingParameters pProcessingParams) {
        ArrayList<JmxRequest> ret = new ArrayList<JmxRequest>();
        for (Object o : pJsonRequests) {
            if (!(o instanceof Map)) {
                throw new IllegalArgumentException("Not a request within the list of requests " + pJsonRequests + ". Expected map, but found: " + o);
            }
            ret.add((JmxRequest)JmxRequestFactory.createPostRequest((Map)o, pProcessingParams));
        }
        return ret;
    }

    private static String extractPathInfo(String pPathInfo, ProcessingParameters pProcessingParams) {
        String pathInfo = pPathInfo;
        if (pProcessingParams != null && (pPathInfo == null || pPathInfo.length() == 0 || pathInfo.matches("^/+$"))) {
            pathInfo = pProcessingParams.getPathInfo();
        }
        return JmxRequestFactory.normalizePathInfo(pathInfo);
    }

    private static String normalizePathInfo(String pPathInfo) {
        if (pPathInfo != null && pPathInfo.length() > 0) {
            return pPathInfo.startsWith("/") ? pPathInfo.substring(1) : pPathInfo;
        }
        return "";
    }

    private static RequestCreator getCreator(RequestType pType) {
        RequestCreator creator = CREATOR_MAP.get((Object)pType);
        if (creator == null) {
            throw new UnsupportedOperationException("Type " + (Object)((Object)pType) + " is not supported (yet)");
        }
        return creator;
    }

    static {
        CREATOR_MAP.put(RequestType.READ, JmxReadRequest.newCreator());
        CREATOR_MAP.put(RequestType.WRITE, JmxWriteRequest.newCreator());
        CREATOR_MAP.put(RequestType.EXEC, JmxExecRequest.newCreator());
        CREATOR_MAP.put(RequestType.LIST, JmxListRequest.newCreator());
        CREATOR_MAP.put(RequestType.VERSION, JmxVersionRequest.newCreator());
        CREATOR_MAP.put(RequestType.SEARCH, JmxSearchRequest.newCreator());
    }
}

