//! Implementation of Wasmtime's system primitives for Windows.

use std::cell::Cell;

pub mod mmap;
pub mod traphandlers;
pub mod unwind;
pub mod vm;

std::thread_local!(static TLS: Cell<*mut u8> = const { Cell::new(std::ptr::null_mut()) });

#[inline]
pub fn tls_get() -> *mut u8 {
    TLS.with(|p| p.get())
}

#[inline]
pub fn tls_set(ptr: *mut u8) {
    TLS.with(|p| p.set(ptr));
}
