/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.java.InstancesContainer;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;

class GCTypeNode
extends InstancesContainer.Objects {
    private int gcRoots;
    private Map<Instance, Long> gcRootMap = new HashMap<Instance, Long>();

    GCTypeNode(String name) {
        super(name, DataType.CLASS.getUnsupportedValue());
    }

    @Override
    protected String getMoreNodesString(String moreNodesCount) {
        return Bundle.ClassesContainer_MoreNodes(moreNodesCount);
    }

    @Override
    protected String getSamplesContainerString(String objectsCount) {
        return Bundle.ClassesContainer_SamplesContainer(objectsCount);
    }

    @Override
    protected String getNodesContainerString(String firstNodeIdx, String lastNodeIdx) {
        return Bundle.ClassesContainer_NodesContainer(firstNodeIdx, lastNodeIdx);
    }

    void addRoot(GCRoot gcroot, Instance i, Heap heap) {
        ++this.gcRoots;
        Long count = this.gcRootMap.get(i);
        if (count == null) {
            count = 1L;
            this.add(i, heap);
        } else {
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
        }
        this.gcRootMap.put(i, count);
    }

    @Override
    protected InstanceNode createNode(Instance instance) {
        return new GCInstanceNode(instance);
    }

    @Override
    protected Object getValue(DataType type, Heap heap) {
        if (type == DataType.GCROOTS) {
            return this.gcRoots;
        }
        return super.getValue(type, heap);
    }

    private class GCInstanceNode
    extends InstanceNode {
        private GCInstanceNode(Instance instance) {
            super(instance);
        }

        @Override
        protected Object getValue(DataType type, Heap heap) {
            if (type == DataType.GCROOTS) {
                return GCTypeNode.this.gcRootMap.get(this.getInstance());
            }
            return super.getValue(type, heap);
        }
    }

    static class Renderer
    extends LabelRenderer
    implements HeapViewerRenderer {
        Renderer() {
            this.setIcon(Icons.getIcon((String)"ProfilerIcons.RunGC"));
            this.setFont(this.getFont().deriveFont(1));
        }
    }
}

