/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.coin.EndpointProvider;
import org.jitsi.xmpp.extensions.coin.ParsingUtils;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jitsi.xmpp.extensions.coin.UserPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class UserProvider
extends ExtensionElementProvider<UserPacketExtension> {
    @Override
    public UserPacketExtension parse(XmlPullParser parser2, int depth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        boolean done = false;
        String entity = parser2.getAttributeValue("", "entity");
        StateType state = StateType.full;
        String stateStr = parser2.getAttributeValue("", "state");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        if (entity == null) {
            throw new SmackParsingException.RequiredAttributeMissingException("Coin user element must contain entity attribute");
        }
        UserPacketExtension ext = new UserPacketExtension(entity);
        ext.setAttribute("state", (Object)state);
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String elementName = parser2.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (elementName.equals("display-text")) {
                    ext.setDisplayText(ParsingUtils.parseText(parser2));
                    continue;
                }
                if (!elementName.equals("endpoint")) continue;
                EndpointProvider provider = new EndpointProvider();
                ext.addChildExtension((ExtensionElement)provider.parse(parser2));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("user")) continue;
            done = true;
        }
        return ext;
    }
}

