/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.Chronology;
import java.time.chrono.Ser;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class ChronoPeriodImpl
implements ChronoPeriod,
Serializable {
    private static final long serialVersionUID = 57387258289L;
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS));
    private final Chronology chrono;
    final int years;
    final int months;
    final int days;

    ChronoPeriodImpl(Chronology chronology, int n, int n2, int n3) {
        Objects.requireNonNull(chronology, "chrono");
        this.chrono = chronology;
        this.years = n;
        this.months = n2;
        this.days = n3;
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        if (temporalUnit == ChronoUnit.YEARS) {
            return this.years;
        }
        if (temporalUnit == ChronoUnit.MONTHS) {
            return this.months;
        }
        if (temporalUnit == ChronoUnit.DAYS) {
            return this.days;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + temporalUnit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Chronology getChronology() {
        return this.chrono;
    }

    @Override
    public boolean isZero() {
        return this.years == 0 && this.months == 0 && this.days == 0;
    }

    @Override
    public boolean isNegative() {
        return this.years < 0 || this.months < 0 || this.days < 0;
    }

    @Override
    public ChronoPeriod plus(TemporalAmount temporalAmount) {
        ChronoPeriodImpl chronoPeriodImpl = this.validateAmount(temporalAmount);
        return new ChronoPeriodImpl(this.chrono, Math.addExact(this.years, chronoPeriodImpl.years), Math.addExact(this.months, chronoPeriodImpl.months), Math.addExact(this.days, chronoPeriodImpl.days));
    }

    @Override
    public ChronoPeriod minus(TemporalAmount temporalAmount) {
        ChronoPeriodImpl chronoPeriodImpl = this.validateAmount(temporalAmount);
        return new ChronoPeriodImpl(this.chrono, Math.subtractExact(this.years, chronoPeriodImpl.years), Math.subtractExact(this.months, chronoPeriodImpl.months), Math.subtractExact(this.days, chronoPeriodImpl.days));
    }

    private ChronoPeriodImpl validateAmount(TemporalAmount temporalAmount) {
        Objects.requireNonNull(temporalAmount, "amount");
        if (!(temporalAmount instanceof ChronoPeriodImpl)) {
            throw new DateTimeException("Unable to obtain ChronoPeriod from TemporalAmount: " + temporalAmount.getClass());
        }
        ChronoPeriodImpl chronoPeriodImpl = (ChronoPeriodImpl)temporalAmount;
        if (!this.chrono.equals(chronoPeriodImpl.getChronology())) {
            throw new ClassCastException("Chronology mismatch, expected: " + this.chrono.getId() + ", actual: " + chronoPeriodImpl.getChronology().getId());
        }
        return chronoPeriodImpl;
    }

    @Override
    public ChronoPeriod multipliedBy(int n) {
        if (this.isZero() || n == 1) {
            return this;
        }
        return new ChronoPeriodImpl(this.chrono, Math.multiplyExact(this.years, n), Math.multiplyExact(this.months, n), Math.multiplyExact(this.days, n));
    }

    @Override
    public ChronoPeriod normalized() {
        long l = this.monthRange();
        if (l > 0L) {
            long l2 = (long)this.years * l + (long)this.months;
            long l3 = l2 / l;
            int n = (int)(l2 % l);
            if (l3 == (long)this.years && n == this.months) {
                return this;
            }
            return new ChronoPeriodImpl(this.chrono, Math.toIntExact(l3), n, this.days);
        }
        return this;
    }

    private long monthRange() {
        ValueRange valueRange = this.chrono.range(ChronoField.MONTH_OF_YEAR);
        if (valueRange.isFixed() && valueRange.isIntValue()) {
            return valueRange.getMaximum() - valueRange.getMinimum() + 1L;
        }
        return -1L;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        this.validateChrono(temporal);
        if (this.months == 0) {
            if (this.years != 0) {
                temporal = temporal.plus(this.years, ChronoUnit.YEARS);
            }
        } else {
            long l = this.monthRange();
            if (l > 0L) {
                temporal = temporal.plus((long)this.years * l + (long)this.months, ChronoUnit.MONTHS);
            } else {
                if (this.years != 0) {
                    temporal = temporal.plus(this.years, ChronoUnit.YEARS);
                }
                temporal = temporal.plus(this.months, ChronoUnit.MONTHS);
            }
        }
        if (this.days != 0) {
            temporal = temporal.plus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        this.validateChrono(temporal);
        if (this.months == 0) {
            if (this.years != 0) {
                temporal = temporal.minus(this.years, ChronoUnit.YEARS);
            }
        } else {
            long l = this.monthRange();
            if (l > 0L) {
                temporal = temporal.minus((long)this.years * l + (long)this.months, ChronoUnit.MONTHS);
            } else {
                if (this.years != 0) {
                    temporal = temporal.minus(this.years, ChronoUnit.YEARS);
                }
                temporal = temporal.minus(this.months, ChronoUnit.MONTHS);
            }
        }
        if (this.days != 0) {
            temporal = temporal.minus(this.days, ChronoUnit.DAYS);
        }
        return temporal;
    }

    private void validateChrono(TemporalAccessor temporalAccessor) {
        Objects.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = temporalAccessor.query(TemporalQueries.chronology());
        if (chronology != null && !this.chrono.equals(chronology)) {
            throw new DateTimeException("Chronology mismatch, expected: " + this.chrono.getId() + ", actual: " + chronology.getId());
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoPeriodImpl) {
            ChronoPeriodImpl chronoPeriodImpl = (ChronoPeriodImpl)object;
            return this.years == chronoPeriodImpl.years && this.months == chronoPeriodImpl.months && this.days == chronoPeriodImpl.days && this.chrono.equals(chronoPeriodImpl.chrono);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.years + Integer.rotateLeft(this.months, 8) + Integer.rotateLeft(this.days, 16) ^ this.chrono.hashCode();
    }

    @Override
    public String toString() {
        if (this.isZero()) {
            return this.getChronology().toString() + " P0D";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getChronology().toString()).append(' ').append('P');
        if (this.years != 0) {
            stringBuilder.append(this.years).append('Y');
        }
        if (this.months != 0) {
            stringBuilder.append(this.months).append('M');
        }
        if (this.days != 0) {
            stringBuilder.append(this.days).append('D');
        }
        return stringBuilder.toString();
    }

    protected Object writeReplace() {
        return new Ser(9, this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ObjectStreamException {
        throw new InvalidObjectException("Deserialization via serialization delegate");
    }

    void writeExternal(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.chrono.getId());
        dataOutput.writeInt(this.years);
        dataOutput.writeInt(this.months);
        dataOutput.writeInt(this.days);
    }

    static ChronoPeriodImpl readExternal(DataInput dataInput) throws IOException {
        Chronology chronology = Chronology.of(dataInput.readUTF());
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        return new ChronoPeriodImpl(chronology, n, n2, n3);
    }
}

