/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transfer;

import java.io.File;
import org.eclipse.aether.RequestTrace;

public final class TransferResource {
    private final String repositoryId;
    private final String repositoryUrl;
    private final String resourceName;
    private final File file;
    private final long startTime;
    private final RequestTrace trace;
    private long contentLength = -1L;
    private long resumeOffset;

    @Deprecated
    public TransferResource(String repositoryUrl, String resourceName, File file2, RequestTrace trace2) {
        this(null, repositoryUrl, resourceName, file2, trace2);
    }

    public TransferResource(String repositoryId, String repositoryUrl, String resourceName, File file2, RequestTrace trace2) {
        this.repositoryId = repositoryId == null || repositoryId.isEmpty() ? "" : repositoryId;
        this.repositoryUrl = repositoryUrl == null || repositoryUrl.isEmpty() ? "" : (repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + '/');
        this.resourceName = resourceName == null || resourceName.isEmpty() ? "" : (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.file = file2;
        this.trace = trace2;
        this.startTime = System.currentTimeMillis();
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public TransferResource setContentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public long getResumeOffset() {
        return this.resumeOffset;
    }

    public TransferResource setResumeOffset(long resumeOffset) {
        if (resumeOffset < 0L) {
            throw new IllegalArgumentException("resume offset cannot be negative");
        }
        this.resumeOffset = resumeOffset;
        return this;
    }

    public long getTransferStartTime() {
        return this.startTime;
    }

    public RequestTrace getTrace() {
        return this.trace;
    }

    public String toString() {
        return this.getRepositoryUrl() + this.getResourceName() + " <> " + this.getFile();
    }
}

