/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.profiler.ProfilerSettingsSupport;
import org.graalvm.visualvm.profiling.presets.PresetSelector;
import org.graalvm.visualvm.profiling.presets.ProfilerMemoryPanel;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.util.NbBundle;

public abstract class MemorySettingsSupport
extends ProfilerSettingsSupport {
    private JPanel container;
    private ProfilerMemoryPanel panel;
    private PresetSelector selector;
    private DataViewComponent.DetailsView detailsView;

    DataViewComponent.DetailsView getDetailsView() {
        if (this.detailsView == null) {
            this.detailsView = new DataViewComponent.DetailsView(NbBundle.getMessage(MemorySettingsSupport.class, (String)"LBL_Memory_settings"), null, 20, (JComponent)new ScrollableContainer(this.getComponent()), null);
        }
        return this.detailsView;
    }

    public JComponent getComponent() {
        if (this.container == null) {
            this.createPanel();
        }
        return this.container;
    }

    @Override
    public ProfilingSettings getSettings() {
        return this.panel.getSettings();
    }

    public void saveSettings() {
    }

    void updateSettings(ProfilerPreset preset) {
        this.panel.loadFromPreset(preset);
    }

    public abstract boolean presetValid();

    public boolean settingsValid() {
        return this.panel.settingsValid();
    }

    public void showSettings(DataViewComponent dvc) {
        this.panel.highlightInvalid();
        dvc.selectDetailsView(this.getDetailsView());
    }

    public abstract PresetSelector createSelector(Runnable var1);

    public void setEnabled(boolean enabled) {
        this.container.setEnabled(enabled);
    }

    private JPanel createPanel() {
        this.panel = new ProfilerMemoryPanel(){

            public void settingsChanged() {
                MemorySettingsSupport.this.panel.saveToPreset(MemorySettingsSupport.this.selector.customize(MemorySettingsSupport.this.presetValid()));
            }
        };
        this.selector = this.createSelector(new Runnable(){

            @Override
            public void run() {
                MemorySettingsSupport.this.panel.loadFromPreset(MemorySettingsSupport.this.selector.getSelectedPreset());
            }
        });
        this.selector.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.container = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                for (Component c : this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        this.container.setOpaque(false);
        this.container.add((Component)this.panel, "Center");
        this.container.add((Component)this.selector, "South");
        return this.container;
    }
}

