/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.tabection;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.control.icons.CircleFactories;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabAction;
import com.intellij.openapi.wm.impl.content.tabActions.ContentTabActionProvider;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.jetbrains.codeWithMe.model.RdUserModel;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u0011"}, d2={"Lcom/intellij/cwm/plugin/common/tabection/CWMContentTabActionProvider;", "Lcom/intellij/openapi/wm/impl/content/tabActions/ContentTabActionProvider;", "<init>", "()V", "createTabActions", "", "Lcom/intellij/openapi/wm/impl/content/tabActions/ContentTabAction;", "content", "Lcom/intellij/ui/content/Content;", "createAction", "project", "Lcom/intellij/openapi/project/Project;", "toolWindowId", "", "getUsersFor", "Lcom/intellij/codeWithMe/ClientId;", "CWMUsersIcon", "intellij.cwm.plugin.common"})
public abstract class CWMContentTabActionProvider
implements ContentTabActionProvider {
    @NotNull
    public List<ContentTabAction> createTabActions(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ContentManager contentManager = content.getManager();
        ContentManagerImpl contentManagerImpl = contentManager instanceof ContentManagerImpl ? (ContentManagerImpl)contentManager : null;
        if (contentManagerImpl == null) {
            return CollectionsKt.emptyList();
        }
        ContentManagerImpl contentManager2 = contentManagerImpl;
        ContentUI contentUI = contentManager2.getUI();
        ToolWindowContentUi toolWindowContentUi = contentUI instanceof ToolWindowContentUi ? (ToolWindowContentUi)contentUI : null;
        if (toolWindowContentUi == null) {
            return CollectionsKt.emptyList();
        }
        ToolWindowContentUi contentUi = toolWindowContentUi;
        ToolWindow toolWindow = contentUi.getWindow();
        ToolWindowEx toolWindowEx = toolWindow instanceof ToolWindowEx ? (ToolWindowEx)toolWindow : null;
        if (toolWindowEx == null) {
            return CollectionsKt.emptyList();
        }
        ToolWindowEx toolWindow2 = toolWindowEx;
        Project project = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!UserManager.Companion.getInstance(project).getCwmActionsAllowed()) {
            return CollectionsKt.emptyList();
        }
        Project project2 = toolWindow2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = toolWindow2.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return CollectionsKt.listOf((Object)this.createAction(project2, string, content));
    }

    private final ContentTabAction createAction(Project project, String toolWindowId, Content content) {
        CWMUsersIcon cwmIcon = new CWMUsersIcon(project, toolWindowId, content);
        ActiveIcon activeIcon = new ActiveIcon((Icon)cwmIcon);
        return new ContentTabAction(project, this, toolWindowId, content, activeIcon){
            final /* synthetic */ Project $project;
            final /* synthetic */ CWMContentTabActionProvider this$0;
            final /* synthetic */ String $toolWindowId;
            final /* synthetic */ Content $content;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$toolWindowId = $toolWindowId;
                this.$content = $content;
                super($super_call_param$1);
            }

            public boolean getAvailable() {
                return !this.$project.isDisposed() && !((Collection)this.this$0.getUsersFor(this.$project, this.$toolWindowId, this.$content)).isEmpty();
            }

            public void runAction() {
            }
        };
    }

    @NotNull
    public abstract List<ClientId> getUsersFor(@NotNull Project var1, @NotNull String var2, @NotNull Content var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/cwm/plugin/common/tabection/CWMContentTabActionProvider$CWMUsersIcon;", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "toolWindowId", "", "content", "Lcom/intellij/ui/content/Content;", "<init>", "(Lcom/intellij/cwm/plugin/common/tabection/CWMContentTabActionProvider;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/ui/content/Content;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getToolWindowId", "()Ljava/lang/String;", "getContent", "()Lcom/intellij/ui/content/Content;", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "intellij.cwm.plugin.common"})
    @SourceDebugExtension(value={"SMAP\nCodeWithMeTabAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeWithMeTabAction.kt\ncom/intellij/cwm/plugin/common/tabection/CWMContentTabActionProvider$CWMUsersIcon\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    private final class CWMUsersIcon
    implements Icon {
        @NotNull
        private final Project project;
        @NotNull
        private final String toolWindowId;
        @NotNull
        private final Content content;

        public CWMUsersIcon(@NotNull Project project, @NotNull String toolWindowId, Content content) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.project = project;
            this.toolWindowId = toolWindowId;
            this.content = content;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getToolWindowId() {
            return this.toolWindowId;
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        @Override
        public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            List<ClientId> users = CWMContentTabActionProvider.this.getUsersFor(this.project, this.toolWindowId, this.content);
            if (users.isEmpty()) {
                return;
            }
            int maxCirclesCount = 2;
            int offset = 0;
            int n = RangesKt.coerceAtMost((int)users.size(), (int)maxCirclesCount);
            for (int i = 0; i < n; ++i) {
                RdUserModel user;
                Object v0;
                block4: {
                    Iterable iterable = (Iterable)UserManager.Companion.getInstance(this.project).getUsers();
                    for (Object t : iterable) {
                        RdUserModel it = (RdUserModel)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)UserManagerKt.getClientId(it), (Object)users.get(i))) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                if ((RdUserModel)v0 == null) continue;
                Icon icon = CircleFactories.Companion.createUsersTabIcon(user);
                icon.paintIcon(c, g, x + offset, y);
                offset += icon.getIconWidth();
            }
            if (users.size() > maxCirclesCount) {
                Icon moreIcon = CircleFactories.Companion.createMoreUsersIcon(users.size() - maxCirclesCount);
                moreIcon.paintIcon(c, g, x + offset, y);
            }
        }

        @Override
        public int getIconWidth() {
            List<ClientId> users = CWMContentTabActionProvider.this.getUsersFor(this.project, this.toolWindowId, this.content);
            int size = RangesKt.coerceAtMost((int)users.size(), (int)3);
            return size * ((Number)CircleFactories.Companion.getICON_SIZE().invoke()).intValue();
        }

        @Override
        public int getIconHeight() {
            return ((Number)CircleFactories.Companion.getICON_SIZE().invoke()).intValue();
        }
    }
}

