/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.testFramework.CpuTimings;
import com.intellij.testFramework.IoTimings;
import com.intellij.util.system.CpuArch;
import org.jetbrains.annotations.Range;

public final class Timings {
    public static final long CPU_TIMING = CpuTimings.calcStableCpuTiming();
    public static final long IO_TIMING = IoTimings.calcIoTiming();
    public static final long REFERENCE_CPU_TIMING = 200L;
    public static final long REFERENCE_IO_TIMING = 100L;

    public static @Range(from=1L, to=0x7FFFFFFFL) int adjustAccordingToMySpeed(int value2, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value2 * 200.0 / (double)CPU_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.getJobPoolParallelism() : 1));
    }

    public static String getStatistics() {
        return String.format("CPU=%d (%d%% reference CPU), I/O=%d (%d%% reference IO), %d cores (%s)", CPU_TIMING, CPU_TIMING * 100L / 200L, IO_TIMING, IO_TIMING * 100L / 100L, Runtime.getRuntime().availableProcessors(), CpuArch.CURRENT);
    }
}

