/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.settingsSync.core.GitSettingsLog;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSyncBridge;
import com.intellij.settingsSync.core.SettingsSyncIdeMediator;
import com.intellij.settingsSync.core.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.core.SettingsSyncMainKt;
import com.intellij.settingsSync.core.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.core.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncMain;", "Lcom/intellij/openapi/Disposable;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "appConfigPath", "Ljava/nio/file/Path;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/nio/file/Path;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "controls", "Lcom/intellij/settingsSync/core/SettingsSyncMain$SettingsSyncControls;", "getControls", "()Lcom/intellij/settingsSync/core/SettingsSyncMain$SettingsSyncControls;", "dispose", "", "disableSyncing", "Companion", "SettingsSyncControls", "intellij.settingsSync.core"})
@ApiStatus.Internal
public final class SettingsSyncMain
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsSyncControls controls;

    public SettingsSyncMain(@NotNull CoroutineScope coroutineScope, @NotNull Path appConfigPath) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        ComponentStoreImpl componentStore = (ComponentStoreImpl)iComponentStore;
        SettingsSyncIdeMediatorImpl ideMediator = new SettingsSyncIdeMediatorImpl(componentStore, appConfigPath, (Function0<Boolean>)((Function0)SettingsSyncMain::_init_$lambda$0));
        Disposable disposable = this;
        Path path = appConfigPath.resolve("settingsSync");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.controls = Companion.init$intellij_settingsSync_core(coroutineScope, disposable, path, appConfigPath, ideMediator);
    }

    public SettingsSyncMain(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        this(coroutineScope, path);
    }

    @NotNull
    public final SettingsSyncControls getControls() {
        return this.controls;
    }

    public void dispose() {
    }

    public final void disableSyncing() {
        this.controls.getIdeMediator().removeStreamProvider();
    }

    private static final boolean _init_$lambda$0() {
        return Companion.isAvailable() && SettingsSyncMainKt.isSettingsSyncEnabledInSettings();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\tJ5\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncMain$Companion;", "", "<init>", "()V", "isAvailable", "", "getInstance", "Lcom/intellij/settingsSync/core/SettingsSyncMain;", "getInstanceAsync", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "init", "Lcom/intellij/settingsSync/core/SettingsSyncMain$SettingsSyncControls;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "appConfigPath", "ideMediator", "Lcom/intellij/settingsSync/core/SettingsSyncIdeMediator;", "init$intellij_settingsSync_core", "intellij.settingsSync.core"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/core/SettingsSyncMain$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,82:1\n58#2:83\n70#2,6:87\n40#3,3:84\n*S KotlinDebug\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/core/SettingsSyncMain$Companion\n*L\n49#1:83\n53#1:87,6\n52#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)application;
            boolean $i$f$serviceIfCreated = false;
            return $this$serviceIfCreated$iv.getServiceIfCreated(SettingsSyncMain.class) != null;
        }

        @NotNull
        public final SettingsSyncMain getInstance() {
            boolean $i$f$service = false;
            Class<SettingsSyncMain> serviceClass$iv = SettingsSyncMain.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (SettingsSyncMain)object;
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Continuation<? super SettingsSyncMain> $completion) {
            boolean $i$f$serviceAsync = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceAsync$iv$iv = (ComponentManager)application;
            boolean $i$f$serviceAsync2 = false;
            return ((ComponentManagerEx)$this$serviceAsync$iv$iv).getServiceAsync(SettingsSyncMain.class, $completion);
        }

        @NotNull
        public final SettingsSyncControls init$intellij_settingsSync_core(@NotNull CoroutineScope coroutineScope, @NotNull Disposable parentDisposable, @NotNull Path settingsSyncStorage, @NotNull Path appConfigPath, @NotNull SettingsSyncIdeMediator ideMediator) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
            Intrinsics.checkNotNullParameter((Object)ideMediator, (String)"ideMediator");
            GitSettingsLog settingsLog = new GitSettingsLog(settingsSyncStorage, appConfigPath, parentDisposable, (Function0<SettingsSyncUserData>)((Function0)Companion::init$lambda$0), (Function1<? super SettingsSnapshot, SettingsSnapshot>)((Function1)arg_0 -> Companion.init$lambda$1(ideMediator, appConfigPath, arg_0)));
            SettingsSyncUpdateChecker updateChecker = new SettingsSyncUpdateChecker();
            SettingsSyncBridge bridge = new SettingsSyncBridge(coroutineScope, appConfigPath, settingsLog, ideMediator, updateChecker);
            return new SettingsSyncControls(ideMediator, updateChecker, bridge, settingsSyncStorage);
        }

        private static final SettingsSyncUserData init$lambda$0() {
            Object object = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
            if (object == null || (object = object.getUserId()) == null) {
                return null;
            }
            Object userId = object;
            SettingsSyncAuthService settingsSyncAuthService = RemoteCommunicatorHolder.INSTANCE.getAuthService();
            return settingsSyncAuthService != null ? settingsSyncAuthService.getUserData((String)userId) : null;
        }

        private static final SettingsSnapshot init$lambda$1(SettingsSyncIdeMediator $ideMediator, Path $appConfigPath, SettingsSnapshot currentSnapshot) {
            Intrinsics.checkNotNullParameter((Object)currentSnapshot, (String)"currentSnapshot");
            return $ideMediator.getInitialSnapshot($appConfigPath, currentSnapshot);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/settingsSync/core/SettingsSyncMain$SettingsSyncControls;", "", "ideMediator", "Lcom/intellij/settingsSync/core/SettingsSyncIdeMediator;", "updateChecker", "Lcom/intellij/settingsSync/core/SettingsSyncUpdateChecker;", "bridge", "Lcom/intellij/settingsSync/core/SettingsSyncBridge;", "settingsSyncStorage", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/settingsSync/core/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/core/SettingsSyncUpdateChecker;Lcom/intellij/settingsSync/core/SettingsSyncBridge;Ljava/nio/file/Path;)V", "getIdeMediator", "()Lcom/intellij/settingsSync/core/SettingsSyncIdeMediator;", "getUpdateChecker", "()Lcom/intellij/settingsSync/core/SettingsSyncUpdateChecker;", "getBridge", "()Lcom/intellij/settingsSync/core/SettingsSyncBridge;", "getSettingsSyncStorage", "()Ljava/nio/file/Path;", "intellij.settingsSync.core"})
    public static final class SettingsSyncControls {
        @NotNull
        private final SettingsSyncIdeMediator ideMediator;
        @NotNull
        private final SettingsSyncUpdateChecker updateChecker;
        @NotNull
        private final SettingsSyncBridge bridge;
        @NotNull
        private final Path settingsSyncStorage;

        public SettingsSyncControls(@NotNull SettingsSyncIdeMediator ideMediator, @NotNull SettingsSyncUpdateChecker updateChecker, @NotNull SettingsSyncBridge bridge, @NotNull Path settingsSyncStorage) {
            Intrinsics.checkNotNullParameter((Object)ideMediator, (String)"ideMediator");
            Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            this.ideMediator = ideMediator;
            this.updateChecker = updateChecker;
            this.bridge = bridge;
            this.settingsSyncStorage = settingsSyncStorage;
        }

        @NotNull
        public final SettingsSyncIdeMediator getIdeMediator() {
            return this.ideMediator;
        }

        @NotNull
        public final SettingsSyncUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        @NotNull
        public final SettingsSyncBridge getBridge() {
            return this.bridge;
        }

        @NotNull
        public final Path getSettingsSyncStorage() {
            return this.settingsSyncStorage;
        }
    }
}

