/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.ConfigurableService;
import org.openhab.core.config.core.ConfigurableServiceUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.i18n.I18nUtil;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.io.rest.LocaleService;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.core.config.ConfigurationService;
import org.openhab.core.io.rest.core.service.ConfigurableServiceDTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="services")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="services")
@Component(service={RESTResource.class, ConfigurableServiceResource.class})
@JaxrsResource
@JaxrsName(value="services")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class ConfigurableServiceResource
implements RESTResource {
    public static final String PATH_SERVICES = "services";
    private final Logger logger = LoggerFactory.getLogger(ConfigurableServiceResource.class);
    private final BundleContext bundleContext;
    private final ConfigDescriptionRegistry configDescRegistry;
    private final ConfigurationService configurationService;
    private final TranslationProvider i18nProvider;
    private final LocaleService localeService;

    @Activate
    public ConfigurableServiceResource(BundleContext bundleContext, @Reference ConfigurationService configurationService, @Reference ConfigDescriptionRegistry configDescRegistry, @Reference TranslationProvider translationProvider, @Reference LocaleService localeService) {
        this.bundleContext = bundleContext;
        this.configDescRegistry = configDescRegistry;
        this.configurationService = configurationService;
        this.i18nProvider = translationProvider;
        this.localeService = localeService;
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getServices", summary="Get all configurable services.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConfigurableServiceDTO.class)))})})
    public List<ConfigurableServiceDTO> getAll(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language) {
        Locale locale = this.localeService.getLocale(language);
        return this.getConfigurableServices(locale);
    }

    @GET
    @Path(value="/{serviceId}")
    @Produces(value={"application/json"})
    @Operation(operationId="getServicesById", summary="Get configurable service for given service ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ConfigurableServiceDTO.class))}), @ApiResponse(responseCode="404", description="Not found")})
    public Response getById(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="serviceId") @Parameter(description="service ID") String serviceId) {
        Locale locale = this.localeService.getLocale(language);
        ConfigurableServiceDTO configurableService = this.getServiceById(serviceId, locale);
        if (configurableService != null) {
            return Response.ok((Object)configurableService).build();
        }
        return Response.status((int)404).build();
    }

    private @Nullable ConfigurableServiceDTO getServiceById(String serviceId, Locale locale) {
        ConfigurableServiceDTO multiService = this.getMultiConfigServiceById(serviceId, locale);
        if (multiService != null) {
            return multiService;
        }
        List<ConfigurableServiceDTO> configurableServices = this.getConfigurableServices(locale);
        for (ConfigurableServiceDTO configurableService : configurableServices) {
            if (!configurableService.id.equals(serviceId)) continue;
            return configurableService;
        }
        return null;
    }

    private @Nullable ConfigurableServiceDTO getMultiConfigServiceById(String serviceId, Locale locale) {
        String filter = "(&(service.pid=" + serviceId + ")(service.factoryPid=*))";
        List<ConfigurableServiceDTO> services = this.getServicesByFilter(filter, locale);
        if (services.size() == 1) {
            return services.getFirst();
        }
        return null;
    }

    @GET
    @Path(value="/{serviceId}/contexts")
    @Produces(value={"application/json"})
    @Operation(operationId="getServiceContext", summary="Get existing multiple context service configurations for the given factory PID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConfigurableServiceDTO.class)))})})
    public List<ConfigurableServiceDTO> getMultiConfigServicesByFactoryPid(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="serviceId") @Parameter(description="service ID") String serviceId) {
        Locale locale = this.localeService.getLocale(language);
        return this.collectServicesById(serviceId, locale);
    }

    private List<ConfigurableServiceDTO> collectServicesById(String serviceId, Locale locale) {
        String filter = "(service.factoryPid=" + serviceId + ")";
        return this.getServicesByFilter(filter, locale);
    }

    @GET
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @Operation(operationId="getServiceConfig", summary="Get service configuration for given service ID.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="500", description="Configuration can not be read due to internal error")})
    public Response getConfiguration(@PathParam(value="serviceId") @Parameter(description="service ID") String serviceId) {
        try {
            Configuration configuration = this.configurationService.get(serviceId);
            return configuration != null ? Response.ok((Object)configuration.getProperties()).build() : Response.ok(Map.of()).build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot get configuration for service {}: ", (Object)serviceId, (Object)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PUT
    @Path(value="/{serviceId}/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(operationId="updateServiceConfig", summary="Updates a service configuration for given service ID and returns the old configuration.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="204", description="No old configuration"), @ApiResponse(responseCode="500", description="Configuration can not be updated due to internal error")})
    public Response updateConfiguration(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="serviceId") @Parameter(description="service ID") String serviceId, @Nullable Map<String, @Nullable Object> configuration) {
        Locale locale = this.localeService.getLocale(language);
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.update(serviceId, new Configuration(this.normalizeConfiguration(configuration, serviceId, locale)));
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration.getProperties()).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot update configuration for service {}: {}", new Object[]{serviceId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private @Nullable Map<String, @Nullable Object> normalizeConfiguration(@Nullable Map<String, @Nullable Object> properties, String serviceId, Locale locale) {
        URI uri;
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        ConfigurableServiceDTO service = this.getServiceById(serviceId, locale);
        if (service == null) {
            return properties;
        }
        try {
            uri = new URI(service.configDescriptionURI);
        }
        catch (URISyntaxException e) {
            this.logger.warn("Not a valid URI: {}", (Object)service.configDescriptionURI);
            return properties;
        }
        ConfigDescription configDesc = this.configDescRegistry.getConfigDescription(uri);
        if (configDesc == null) {
            return properties;
        }
        return ConfigUtil.normalizeTypes(properties, List.of(configDesc));
    }

    @DELETE
    @Path(value="/{serviceId}/config")
    @Produces(value={"application/json"})
    @Operation(operationId="deleteServiceConfig", summary="Deletes a service configuration for given service ID and returns the old configuration.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="204", description="No old configuration"), @ApiResponse(responseCode="500", description="Configuration can not be deleted due to internal error")})
    public Response deleteConfiguration(@PathParam(value="serviceId") @Parameter(description="service ID") String serviceId) {
        try {
            Configuration oldConfiguration = this.configurationService.get(serviceId);
            this.configurationService.delete(serviceId);
            return oldConfiguration != null ? Response.ok((Object)oldConfiguration).build() : Response.noContent().build();
        }
        catch (IOException ex) {
            this.logger.error("Cannot delete configuration for service {}: {}", new Object[]{serviceId, ex.getMessage(), ex});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private List<ConfigurableServiceDTO> getServicesByFilter(String filter, Locale locale) {
        ArrayList<ConfigurableServiceDTO> services = new ArrayList<ConfigurableServiceDTO>();
        ServiceReference[] serviceReferences = null;
        try {
            serviceReferences = this.bundleContext.getServiceReferences(null, filter);
        }
        catch (InvalidSyntaxException ex) {
            this.logger.error("Cannot get service references because the syntax of the filter '{}' is invalid.", (Object)filter);
        }
        if (serviceReferences != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceReference = serviceReferenceArray[n2];
                String id = this.getServiceId(serviceReference);
                ConfigurableService configurableService = ConfigurableServiceUtil.asConfigurableService(arg_0 -> ((ServiceReference)serviceReference).getProperty(arg_0));
                String defaultLabel = configurableService.label();
                if (defaultLabel.isEmpty()) {
                    defaultLabel = this.configurationService.getProperty(id, "openhab.servicecontext");
                }
                String key = I18nUtil.stripConstantOr((String)defaultLabel, () -> this.inferKey(configurableService.description_uri(), "label"));
                String label = this.i18nProvider.getText("system:addons".equals(configurableService.description_uri()) ? FrameworkUtil.getBundle(OpenHAB.class) : serviceReference.getBundle(), key, defaultLabel, locale);
                String category = configurableService.category();
                String configDescriptionURI = configurableService.description_uri();
                if (configDescriptionURI.isEmpty()) {
                    String factoryPid = (String)serviceReference.getProperty("service.factoryPid");
                    configDescriptionURI = this.getConfigDescriptionByFactoryPid(factoryPid);
                }
                boolean multiple = configurableService.factory();
                services.add(new ConfigurableServiceDTO(id, label == null ? defaultLabel : label, category, configDescriptionURI, multiple));
                ++n2;
            }
        }
        return services;
    }

    private @Nullable String getConfigDescriptionByFactoryPid(String factoryPid) {
        String configDescriptionURI = null;
        String filter = "(service.pid=" + factoryPid + ")";
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(null, filter);
            if (refs != null && refs.length > 0) {
                ConfigurableService configurableService = ConfigurableServiceUtil.asConfigurableService(key -> refs[0].getProperty(key));
                configDescriptionURI = configurableService.description_uri();
            }
        }
        catch (InvalidSyntaxException e) {
            this.logger.error("Cannot get service references because the syntax of the filter '{}' is invalid.", (Object)filter);
        }
        return configDescriptionURI;
    }

    private List<ConfigurableServiceDTO> getConfigurableServices(Locale locale) {
        ArrayList<ConfigurableServiceDTO> services = new ArrayList<ConfigurableServiceDTO>();
        services.addAll(this.getServicesByFilter("(&(service.config.description.uri=*)(!(service.config.factory=*)))", locale));
        services.addAll(this.getServicesByFilter("(service.config.factory=*)", locale));
        return services;
    }

    private String getServiceId(ServiceReference<?> serviceReference) {
        String serviceId;
        String cn = (String)serviceReference.getProperty("component.name");
        Object pid = serviceReference.getProperty("service.pid");
        if (pid == null) {
            return cn;
        }
        if (pid instanceof String) {
            String string;
            serviceId = string = (String)pid;
        } else if (pid instanceof String[]) {
            String[] pids = (String[])pid;
            serviceId = this.getServicePID(cn, Arrays.asList(pids));
        } else if (pid instanceof Collection) {
            Collection pids = (Collection)pid;
            serviceId = this.getServicePID(cn, pids.stream().map(Object::toString).toList());
        } else {
            this.logger.warn("The component \"{}\" is using an unhandled service PID type ({}). Use component name.", (Object)cn, pid.getClass());
            serviceId = cn;
        }
        if (serviceId.isEmpty()) {
            this.logger.debug("Missing service PID for component \"{}\", use component name.", (Object)cn);
            return cn;
        }
        return serviceId;
    }

    private String getServicePID(String cn, List<String> pids) {
        switch (pids.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return pids.getFirst();
            }
        }
        String first = pids.getFirst();
        boolean differences = false;
        int i = 1;
        while (i < pids.size()) {
            if (!first.equals(pids.get(i))) {
                differences = true;
                break;
            }
            ++i;
        }
        if (differences) {
            this.logger.warn("The component \"{}\" is using different service PIDs ({}). Different service PIDs are not supported, the first one ({}) is used.", new Object[]{cn, pids, first});
        }
        return first;
    }

    private String inferKey(String uri, String lastSegment) {
        return "service." + uri.replace(":", ".") + "." + lastSegment;
    }
}

