/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.DeclarationInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodPredicates;
import io.quarkus.arc.processor.bcextensions.ParameterInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.ParameterInfo;
import jakarta.enterprise.lang.model.types.TypeVariable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.MutableAnnotationOverlay;
import org.jboss.jandex.Type;

class MethodInfoImpl
extends DeclarationInfoImpl<org.jboss.jandex.MethodInfo>
implements MethodInfo {
    MethodInfoImpl(IndexView jandexIndex, MutableAnnotationOverlay annotationOverlay, org.jboss.jandex.MethodInfo jandexDeclaration) {
        super(jandexIndex, annotationOverlay, jandexDeclaration);
    }

    public String name() {
        if (this.isConstructor()) {
            return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass().name().toString();
        }
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).name();
    }

    public List<ParameterInfo> parameters() {
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).parametersCount());
        for (MethodParameterInfo jandexParameter : ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).parameters()) {
            result.add(new ParameterInfoImpl(this.jandexIndex, this.annotationOverlay, jandexParameter));
        }
        return result;
    }

    public jakarta.enterprise.lang.model.types.Type returnType() {
        if (this.isConstructor()) {
            AnnotationInstance[] typeAnnotations = ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).returnType().annotations().toArray(new AnnotationInstance[0]);
            Type classType = Type.createWithAnnotations((DotName)((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass().name(), (Type.Kind)Type.Kind.CLASS, (AnnotationInstance[])typeAnnotations);
            return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, classType);
        }
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).returnType());
    }

    public jakarta.enterprise.lang.model.types.Type receiverType() {
        if (Modifier.isStatic(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags())) {
            return null;
        }
        if (MethodPredicates.IS_CONSTRUCTOR_JANDEX.test((org.jboss.jandex.MethodInfo)this.jandexDeclaration)) {
            org.jboss.jandex.ClassInfo declaringClass = ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass();
            ClassInfo.NestingType nestingType = declaringClass.nestingType();
            if (nestingType == ClassInfo.NestingType.TOP_LEVEL) {
                return null;
            }
            if (nestingType == ClassInfo.NestingType.INNER && Modifier.isStatic(declaringClass.flags())) {
                return null;
            }
        }
        return TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).receiverType());
    }

    public List<jakarta.enterprise.lang.model.types.Type> throwsTypes() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).exceptions().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, it)).toList();
    }

    public List<TypeVariable> typeParameters() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).typeParameters().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlay, (Type)it)).filter(jakarta.enterprise.lang.model.types.Type::isTypeVariable).map(jakarta.enterprise.lang.model.types.Type::asTypeVariable).toList();
    }

    public boolean isConstructor() {
        return MethodPredicates.IS_CONSTRUCTOR_JANDEX.test((org.jboss.jandex.MethodInfo)this.jandexDeclaration);
    }

    public boolean isStatic() {
        return Modifier.isStatic(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public boolean isFinal() {
        return Modifier.isFinal(((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags());
    }

    public int modifiers() {
        return ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).flags();
    }

    public ClassInfo declaringClass() {
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlay, ((org.jboss.jandex.MethodInfo)this.jandexDeclaration).declaringClass());
    }

    @Override
    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        DotName annotationName = DotName.createSimple(annotationType);
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            if (!annotation.name().equals((Object)annotationName) || annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAnnotation(Predicate<AnnotationInfo> predicate) {
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            if (!predicate.test(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation)) || annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends Annotation> AnnotationInfo annotation(Class<T> annotationType) {
        AnnotationInstance jandexAnnotation = this.annotationOverlay.annotation(this.jandexDeclaration, annotationType);
        if (jandexAnnotation == null || jandexAnnotation.target() == null || jandexAnnotation.target().kind() != AnnotationTarget.Kind.METHOD) {
            return null;
        }
        return new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, jandexAnnotation);
    }

    @Override
    public <T extends Annotation> Collection<AnnotationInfo> repeatableAnnotation(Class<T> annotationType) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotationsWithRepeatable(this.jandexDeclaration, annotationType)) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInfo> annotations(Predicate<AnnotationInfo> predicate) {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            AnnotationInfoImpl annotationInfo;
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD || !predicate.test(annotationInfo = new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation))) continue;
            result.add(annotationInfo);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Collection<AnnotationInfo> annotations() {
        ArrayList<AnnotationInfoImpl> result = new ArrayList<AnnotationInfoImpl>();
        for (AnnotationInstance annotation : this.annotationOverlay.annotations(this.jandexDeclaration)) {
            if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            result.add(new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlay, annotation));
        }
        return Collections.unmodifiableList(result);
    }
}

