/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2np;

import net.i2p.I2PAppContext;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.util.Log;

public class I2NPMessageHandler {
    private final Log _log;
    private final I2PAppContext _context;
    private I2NPMessage _lastRead;

    public I2NPMessageHandler(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(I2NPMessageHandler.class);
    }

    public I2NPMessage lastRead() {
        I2NPMessage rv = this._lastRead;
        this._lastRead = null;
        return rv;
    }

    public I2NPMessage readMessage(byte[] data) throws I2NPMessageException {
        this.readMessage(data, 0, data.length);
        return this.lastRead();
    }

    public int readMessage(byte[] data, int offset) throws I2NPMessageException {
        return this.readMessage(data, offset, data.length - offset);
    }

    public int readMessage(byte[] data, int offset, int maxLen) throws I2NPMessageException {
        int lastSize;
        int cur = offset;
        int type = data[cur] & 0xFF;
        ++cur;
        I2NPMessage msg = I2NPMessageImpl.createMessage(this._context, type);
        try {
            lastSize = msg.readBytes(data, type, cur, maxLen - 1);
        }
        catch (I2NPMessageException ime) {
            throw ime;
        }
        catch (RuntimeException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error reading the stream", e);
            }
            throw new I2NPMessageException("Unknown error reading the " + msg.getClass().getSimpleName(), e);
        }
        this._lastRead = msg;
        return (cur += lastSize) - offset;
    }
}

