/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.FieldIdItem;
import com.googlecode.d2j.dex.writer.item.MethodIdItem;
import java.util.Objects;

public class MethodHandleItem
extends BaseItem
implements Comparable<MethodHandleItem> {
    public int type;
    public FieldIdItem field;
    public MethodIdItem method;

    @Override
    public void write(DataOut out) {
        out.ushort("method_handle_type", this.type);
        out.ushort("unused", 0);
        out.ushort("field_or_method_id", this.field != null ? this.field.index : this.method.index);
        out.ushort("unused", 0);
    }

    @Override
    public int place(int offset) {
        return offset + 8;
    }

    @Override
    public int compareTo(MethodHandleItem o) {
        if (o == null) {
            return 1;
        }
        int x = Integer.compare(this.type, o.type);
        if (x != 0) {
            return x;
        }
        if (this.field != null) {
            return this.field.compareTo(o.field);
        }
        if (this.method != null) {
            return this.method.compareTo(o.method);
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHandleItem that = (MethodHandleItem)o;
        return this.type == that.type && Objects.equals(this.field, that.field) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.field, this.method);
    }
}

