/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SnapshotCollection
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(UserDefinedSQLType.class, DomainCategory.class, SPObjectSnapshot.class)));
    private final List<SPObjectSnapshot<?>> spobjectSnapshots = new ArrayList();
    private final List<UserDefinedSQLType> udtSnapshots = new ArrayList<UserDefinedSQLType>();
    private final List<DomainCategory> categorySnapshots = new ArrayList<DomainCategory>();

    public SnapshotCollection() {
        this.setName("Default snapshot collection");
    }

    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SPObjectSnapshot) {
            this.addSPObjectSnapshot((SPObjectSnapshot)child, index);
        } else if (child instanceof UserDefinedSQLType) {
            this.addUDTSnapshot((UserDefinedSQLType)child, index);
        } else if (child instanceof DomainCategory) {
            this.addCategorySnapshot((DomainCategory)child, index);
        }
    }

    public void addCategorySnapshot(DomainCategory domainCategory, int index) {
        this.categorySnapshots.add(index, domainCategory);
        domainCategory.setParent((SPObject)this);
        this.fireChildAdded(DomainCategory.class, (SPObject)domainCategory, index);
    }

    public void addUDTSnapshot(UserDefinedSQLType sqlType, int index) {
        this.udtSnapshots.add(index, sqlType);
        sqlType.setParent((SPObject)this);
        this.fireChildAdded(UserDefinedSQLType.class, (SPObject)sqlType, index);
    }

    public boolean removeUDTSnapshot(UserDefinedSQLType child) {
        int index = this.udtSnapshots.indexOf(child);
        boolean removed = this.udtSnapshots.remove(child);
        if (removed) {
            this.fireChildRemoved(UserDefinedSQLType.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public boolean removeCategorySnapshot(DomainCategory child) {
        int index = this.categorySnapshots.indexOf((Object)child);
        boolean removed = this.categorySnapshots.remove((Object)child);
        if (removed) {
            this.fireChildRemoved(DomainCategory.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SPObjectSnapshot) {
            return this.removeSPObjectSnapshot((SPObjectSnapshot)child);
        }
        if (child instanceof UserDefinedSQLType) {
            return this.removeUDTSnapshot((UserDefinedSQLType)child);
        }
        if (child instanceof DomainCategory) {
            return this.removeCategorySnapshot((DomainCategory)child);
        }
        return false;
    }

    @Transient
    @Accessor
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @NonProperty
    public List<? extends SPObject> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(this.udtSnapshots);
        children.addAll(this.categorySnapshots);
        children.addAll(this.spobjectSnapshots);
        return Collections.unmodifiableList(children);
    }

    @NonBound
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
        for (UserDefinedSQLType userDefinedSQLType : this.udtSnapshots) {
            userDefinedSQLType.removeDependency(dependency);
        }
        for (DomainCategory domainCategory : this.categorySnapshots) {
            domainCategory.removeDependency(dependency);
        }
        for (SPObjectSnapshot sPObjectSnapshot : this.spobjectSnapshots) {
            sPObjectSnapshot.removeDependency(dependency);
        }
    }

    public boolean removeSPObjectSnapshot(SPObjectSnapshot<?> child) {
        int index = this.spobjectSnapshots.indexOf(child);
        boolean removed = this.spobjectSnapshots.remove(child);
        if (removed) {
            this.fireChildRemoved(SPObjectSnapshot.class, (SPObject)child, index);
            child.setParent(null);
        }
        return removed;
    }

    public void addSPObjectSnapshot(SPObjectSnapshot<?> child, int index) {
        this.spobjectSnapshots.add(index, child);
        child.setParent((SPObject)this);
        this.fireChildAdded(SPObjectSnapshot.class, (SPObject)child, index);
    }

    @NonProperty
    public List<SPObjectSnapshot<?>> getSPObjectSnapshots() {
        return Collections.unmodifiableList(this.spobjectSnapshots);
    }
}

