/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.traccar.config.Config;
import org.traccar.config.Keys;

@Singleton
public class LocaleManager {
    private static final String DEFAULT_LANGUAGE = "en";
    private final Path path;
    private final ObjectMapper objectMapper;
    private final Map<String, Map<String, String>> languageBundles = new ConcurrentHashMap<String, Map<String, String>>();

    @Inject
    public LocaleManager(Config config, ObjectMapper objectMapper) {
        this.path = Paths.get(config.getString(Keys.WEB_LOCALIZATION_PATH), new String[0]);
        this.objectMapper = objectMapper;
    }

    public Path getTemplateFile(String root, String path, String language, String fileName) {
        List<String> languages = Stream.of(LocaleManager.sanitizeLanguage(language), DEFAULT_LANGUAGE).filter(Objects::nonNull).toList();
        for (String targetLanguage : languages) {
            Path targetFile = Path.of(root, path, targetLanguage, fileName);
            if (!Files.exists(targetFile, new LinkOption[0])) continue;
            return Paths.get(path, targetLanguage, fileName);
        }
        return null;
    }

    public Map<String, String> getBundle(String language) {
        String resolvedLanguage = Objects.requireNonNullElse(LocaleManager.sanitizeLanguage(language), DEFAULT_LANGUAGE);
        return this.languageBundles.computeIfAbsent(resolvedLanguage, missingLanguage -> {
            Path file;
            Path targetFile = this.path.resolve(missingLanguage + ".json");
            Path path = file = Files.exists(targetFile, new LinkOption[0]) ? targetFile : this.path.resolve("en.json");
            if (Files.exists(file, new LinkOption[0])) {
                Map map;
                block9: {
                    InputStream in = Files.newInputStream(file, new OpenOption[0]);
                    try {
                        map = (Map)this.objectMapper.readValue(in, (TypeReference)new TypeReference<Map<String, String>>(){});
                        if (in == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    in.close();
                }
                return map;
            }
            return Collections.emptyMap();
        });
    }

    public String getString(String language, String key) {
        return this.getBundle(language).get(key);
    }

    private static String sanitizeLanguage(String language) {
        if (language != null && !language.matches("^[A-Za-z0-9_-]+$")) {
            throw new IllegalArgumentException("Invalid language");
        }
        return language;
    }
}

