/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import java.util.Arrays;
import java.util.Objects;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.HotkeysMetric;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.JedisAsserts;

public class HotkeysParams
implements IParams {
    private HotkeysMetric[] metrics;
    private Integer count;
    private Integer duration;
    private Integer sample;
    private int[] slots;

    public static HotkeysParams hotkeysParams() {
        return new HotkeysParams();
    }

    public HotkeysParams metrics(HotkeysMetric ... metrics) {
        JedisAsserts.notNull(metrics, "metrics must not be null");
        JedisAsserts.isTrue(metrics.length > 0, "at least one metric is required");
        this.metrics = metrics;
        return this;
    }

    public HotkeysParams count(int count) {
        JedisAsserts.isTrue(count >= 10 && count <= 64, "count must be between 1 and 64");
        this.count = count;
        return this;
    }

    public HotkeysParams duration(int duration) {
        JedisAsserts.isTrue(duration >= 0, "duration must be >= 0");
        this.duration = duration;
        return this;
    }

    public HotkeysParams sample(int sample) {
        JedisAsserts.isTrue(sample >= 1, "sample must be >= 1");
        this.sample = sample;
        return this;
    }

    public HotkeysParams slots(int ... slots) {
        if (slots != null) {
            for (int slot : slots) {
                JedisAsserts.isTrue(slot >= 0 && slot <= 16383, "each slot must be between 0 and 16383");
            }
        }
        this.slots = slots;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        JedisAsserts.notNull(this.metrics, "metrics must not be null");
        JedisAsserts.isTrue(this.metrics.length > 0, "at least one metric is required");
        args.add(Protocol.Keyword.METRICS);
        args.add(this.metrics.length);
        for (HotkeysMetric metric : this.metrics) {
            args.add(metric);
        }
        if (this.count != null) {
            args.add(Protocol.Keyword.COUNT);
            args.add(this.count);
        }
        if (this.duration != null) {
            args.add(Protocol.Keyword.DURATION);
            args.add(this.duration);
        }
        if (this.sample != null) {
            args.add(Protocol.Keyword.SAMPLE);
            args.add(this.sample);
        }
        if (this.slots != null && this.slots.length > 0) {
            args.add(Protocol.Keyword.SLOTS);
            args.add(this.slots.length);
            for (int slot : this.slots) {
                args.add(slot);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotkeysParams that = (HotkeysParams)o;
        return Arrays.equals(this.metrics, that.metrics) && Objects.equals(this.count, that.count) && Objects.equals(this.duration, that.duration) && Objects.equals(this.sample, that.sample) && Arrays.equals(this.slots, that.slots);
    }

    public int hashCode() {
        int result = Objects.hash(this.count, this.duration, this.sample);
        result = 31 * result + Arrays.hashCode(this.metrics);
        result = 31 * result + Arrays.hashCode(this.slots);
        return result;
    }
}

