/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.impl;

import java.util.HashMap;

public abstract class CommonConfig {
    protected static final String IMPL_NAME = "aalto";
    protected static final String IMPL_VERSION = "0.9";
    protected static final String XSP_IMPLEMENTATION_NAME = "com.azure.xml.implementation.stax2.implName";
    protected static final String XSP_IMPLEMENTATION_VERSION = "com.azure.xml.implementation.stax2.implVersion";
    protected static final String XSP_SUPPORTS_XML11 = "com.azure.xml.implementation.stax2.supportsXml11";
    protected static final String XSP_NAMESPACE_AWARE = "javax.xml.stream.isNamespaceAware";
    protected static final String XSP_PROBLEM_REPORTER = "javax.xml.stream.reporter";
    protected static final String XSP_SUPPORT_XMLID = "com.azure.xml.implementation.stax2.supportXmlId";
    static final int PROP_IMPL_NAME = 1;
    static final int PROP_IMPL_VERSION = 2;
    static final int PROP_SUPPORTS_XML11 = 3;
    static final int PROP_SUPPORTS_XMLID = 4;
    static final HashMap<String, Integer> sStdProperties = new HashMap(16);
    protected int _flags;
    protected int _flagMods;

    protected CommonConfig(int flags, int flagMods) {
        this._flags = flags;
        this._flagMods = flagMods;
    }

    public Object getProperty(String propName, boolean isMandatory) {
        Integer I = sStdProperties.get(propName);
        if (I != null) {
            switch (I) {
                case 1: {
                    return IMPL_NAME;
                }
                case 2: {
                    return IMPL_VERSION;
                }
                case 3: {
                    return Boolean.FALSE;
                }
                case 4: {
                    return Boolean.FALSE;
                }
            }
        }
        if (isMandatory) {
            throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
        }
        return null;
    }

    public boolean isPropertySupported(String propName) {
        return sStdProperties.containsKey(propName);
    }

    public boolean setProperty(String propName, Object value) {
        Integer I = sStdProperties.get(propName);
        if (I != null) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized property '" + propName + "'");
    }

    public abstract String getActualEncoding();

    protected final boolean hasFlag(int flagMask) {
        return (this._flags & flagMask) != 0;
    }

    protected final void setFlag(int flagMask, boolean state) {
        this._flags = state ? (this._flags |= flagMask) : (this._flags &= ~flagMask);
        this._flagMods |= flagMask;
    }

    static {
        sStdProperties.put(XSP_IMPLEMENTATION_NAME, 1);
        sStdProperties.put(XSP_IMPLEMENTATION_VERSION, 2);
        sStdProperties.put(XSP_SUPPORTS_XML11, 3);
        sStdProperties.put(XSP_SUPPORT_XMLID, 4);
        sStdProperties.put("http://java.sun.com/xml/stream/properties/implementation-name", 1);
    }
}

