/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.server.transport;

import io.modelcontextprotocol.server.transport.ServerTransportSecurityException;
import io.modelcontextprotocol.server.transport.ServerTransportSecurityValidator;
import io.modelcontextprotocol.util.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DefaultServerTransportSecurityValidator
implements ServerTransportSecurityValidator {
    private static final String ORIGIN_HEADER = "Origin";
    private static final String HOST_HEADER = "Host";
    private final List<String> allowedOrigins;
    private final List<String> allowedHosts;

    private DefaultServerTransportSecurityValidator(List<String> allowedOrigins, List<String> allowedHosts) {
        Assert.notNull(allowedOrigins, "allowedOrigins must not be null");
        Assert.notNull(allowedHosts, "allowedHosts must not be null");
        this.allowedOrigins = allowedOrigins;
        this.allowedHosts = allowedHosts;
    }

    @Override
    public void validateHeaders(Map<String, List<String>> headers) throws ServerTransportSecurityException {
        boolean missingHost = true;
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            List<String> values;
            if (ORIGIN_HEADER.equalsIgnoreCase(entry.getKey())) {
                values = entry.getValue();
                if (values == null || values.isEmpty()) {
                    throw new ServerTransportSecurityException(403, "Invalid Origin header");
                }
                this.validateOrigin(values.get(0));
                continue;
            }
            if (!HOST_HEADER.equalsIgnoreCase(entry.getKey())) continue;
            missingHost = false;
            values = entry.getValue();
            if (values == null || values.isEmpty()) {
                throw new ServerTransportSecurityException(421, "Invalid Host header");
            }
            this.validateHost(values.get(0));
        }
        if (!this.allowedHosts.isEmpty() && missingHost) {
            throw new ServerTransportSecurityException(421, "Invalid Host header");
        }
    }

    protected void validateOrigin(String origin) throws ServerTransportSecurityException {
        if (origin == null || origin.isBlank()) {
            return;
        }
        for (String allowed : this.allowedOrigins) {
            String baseOrigin;
            if (allowed.equals(origin)) {
                return;
            }
            if (!allowed.endsWith(":*") || !origin.equals(baseOrigin = allowed.substring(0, allowed.length() - 2)) && !origin.startsWith(baseOrigin + ":")) continue;
            return;
        }
        throw new ServerTransportSecurityException(403, "Invalid Origin header");
    }

    private void validateHost(String host) throws ServerTransportSecurityException {
        if (this.allowedHosts.isEmpty()) {
            return;
        }
        if (host == null || host.isBlank()) {
            throw new ServerTransportSecurityException(421, "Invalid Host header");
        }
        for (String allowed : this.allowedHosts) {
            String baseHost;
            if (allowed.equals(host)) {
                return;
            }
            if (!allowed.endsWith(":*") || !host.equals(baseHost = allowed.substring(0, allowed.length() - 2)) && !host.startsWith(baseHost + ":")) continue;
            return;
        }
        throw new ServerTransportSecurityException(421, "Invalid Host header");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<String> allowedOrigins = new ArrayList<String>();
        private final List<String> allowedHosts = new ArrayList<String>();

        public Builder allowedOrigin(String origin) {
            this.allowedOrigins.add(origin);
            return this;
        }

        public Builder allowedOrigins(List<String> origins) {
            Assert.notNull(origins, "origins must not be null");
            this.allowedOrigins.addAll(origins);
            return this;
        }

        public Builder allowedHost(String host) {
            this.allowedHosts.add(host);
            return this;
        }

        public Builder allowedHosts(List<String> hosts) {
            Assert.notNull(hosts, "hosts must not be null");
            this.allowedHosts.addAll(hosts);
            return this;
        }

        public DefaultServerTransportSecurityValidator build() {
            return new DefaultServerTransportSecurityValidator(this.allowedOrigins, this.allowedHosts);
        }
    }
}

