/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ExperimentalApi;
import io.grpc.ForwardingServerBuilder;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerStreamTracer;
import io.grpc.ServerTransportFilter;
import io.grpc.alts.AltsServerCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4151")
public final class AltsServerBuilder
extends ForwardingServerBuilder<AltsServerBuilder> {
    private final NettyServerBuilder delegate;
    private final AltsServerCredentials.Builder credentialsBuilder = new AltsServerCredentials.Builder();

    private AltsServerBuilder(NettyServerBuilder nettyDelegate) {
        this.delegate = nettyDelegate;
    }

    public static AltsServerBuilder forPort(int port) {
        NettyServerBuilder nettyDelegate = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(port));
        return new AltsServerBuilder(nettyDelegate);
    }

    public AltsServerBuilder enableUntrustedAltsForTesting() {
        this.credentialsBuilder.enableUntrustedAltsForTesting();
        return this;
    }

    public AltsServerBuilder setHandshakerAddressForTesting(String handshakerAddress) {
        this.credentialsBuilder.setHandshakerAddressForTesting(handshakerAddress);
        return this;
    }

    protected ServerBuilder<?> delegate() {
        return this.delegate;
    }

    public AltsServerBuilder handshakeTimeout(long timeout, TimeUnit unit) {
        this.delegate.handshakeTimeout(timeout, unit);
        return this;
    }

    public AltsServerBuilder directExecutor() {
        this.delegate.directExecutor();
        return this;
    }

    public AltsServerBuilder addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        this.delegate.addStreamTracerFactory(factory);
        return this;
    }

    public AltsServerBuilder addTransportFilter(ServerTransportFilter filter) {
        this.delegate.addTransportFilter(filter);
        return this;
    }

    public AltsServerBuilder executor(Executor executor) {
        this.delegate.executor(executor);
        return this;
    }

    public AltsServerBuilder addService(ServerServiceDefinition service) {
        this.delegate.addService(service);
        return this;
    }

    public AltsServerBuilder addService(BindableService bindableService) {
        this.delegate.addService(bindableService);
        return this;
    }

    public AltsServerBuilder fallbackHandlerRegistry(HandlerRegistry fallbackRegistry) {
        this.delegate.fallbackHandlerRegistry(fallbackRegistry);
        return this;
    }

    public AltsServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("Can't set TLS settings for ALTS");
    }

    public AltsServerBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.delegate.decompressorRegistry(registry);
        return this;
    }

    public AltsServerBuilder compressorRegistry(CompressorRegistry registry) {
        this.delegate.compressorRegistry(registry);
        return this;
    }

    public AltsServerBuilder intercept(ServerInterceptor interceptor) {
        this.delegate.intercept(interceptor);
        return this;
    }

    public Server build() {
        this.delegate.protocolNegotiator((ProtocolNegotiator)this.credentialsBuilder.buildProtocolNegotiator());
        return this.delegate.build();
    }
}

