/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import liquibase.Scope;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;

public abstract class AbstractResource
implements Resource {
    private final String path;
    private final String originalPath;
    private final URI uri;

    public AbstractResource(String originalPathParam, URI uri) {
        this.originalPath = originalPathParam;
        this.uri = uri != null ? AbstractResource.handleUriSyntax(uri) : null;
        String calculatedPath = originalPathParam.replace("\\", "/").replaceFirst("^classpath\\*?:", "");
        this.path = uri != null && uri.toString().contains("!") ? this.handlePathForJarfile(calculatedPath) : calculatedPath.replaceFirst("^/", "");
    }

    private String handlePathForJarfile(String path) {
        String relative = this.uri.toString().replaceFirst(".*!", "");
        try {
            if (!((String)path).startsWith("..") && !((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            return new URI(relative).resolve(new URI((String)path).normalize()).toString().replaceFirst("^/", "");
        }
        catch (URISyntaxException e) {
            Scope.getCurrentScope().getLog(AbstractResource.class).warning("Error handling URI syntax for file inside jar. Defaulting to previous behavior.", e);
            return ((String)path).replaceFirst("^/", "");
        }
    }

    private static URI handleUriSyntax(URI uri) {
        if (uri.toString().contains("!")) {
            String[] uriSplit = uri.toString().split("!");
            StringBuilder result = new StringBuilder();
            try {
                for (int i = 0; i < uriSplit.length; ++i) {
                    if (i == uriSplit.length - 1) {
                        result.append(new URI(uriSplit[i]).normalize());
                    } else {
                        result.append(uriSplit[i]);
                    }
                    if (i >= uriSplit.length - 1) continue;
                    result.append("!");
                }
                return new URI(result.toString());
            }
            catch (URISyntaxException e) {
                return uri.normalize();
            }
        }
        return uri.normalize();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String getOriginalPath() {
        return this.originalPath;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public OutputStream openOutputStream(OpenOptions openOptions) throws IOException {
        if (!this.isWritable()) {
            throw new IOException("Read only");
        }
        throw new IOException("Write not implemented");
    }

    public String toString() {
        return this.getPath();
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        return this.getUri().equals(((Resource)obj).getUri());
    }

    protected String resolvePath(String other) {
        if (this.getPath().endsWith("/")) {
            return this.getPath() + other;
        }
        return this.getPath() + "/" + other;
    }

    protected String resolveSiblingPath(String other) {
        if (this.getPath().contains("/")) {
            return this.getPath().replaceFirst("/[^/]*$", "") + "/" + other;
        }
        return "/" + other;
    }
}

