/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ThinkRaceProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 128;
    public static final int MSG_GPS = 144;

    public ThinkRaceProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static double convertCoordinate(long raw, boolean negative) {
        long degrees = raw / 1000000L;
        double minutes = (double)(raw % 1000000L) * 1.0E-4;
        double result = (double)degrees + minutes / 60.0;
        if (negative) {
            result = -result;
        }
        return result;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        ByteBuf id = buf.readSlice(12);
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        if (type == 128) {
            String imei;
            DeviceSession deviceSession;
            short command = buf.readUnsignedByte();
            if (command == 1 && (deviceSession = this.getDeviceSession(channel, remoteAddress, imei = buf.toString(buf.readerIndex(), 15, StandardCharsets.US_ASCII))) != null && channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeByte(72);
                response.writeByte(82);
                response.writeBytes(id);
                response.writeByte(44);
                response.writeByte((int)type);
                response.writeShort(2);
                response.writeShort(32768);
                response.writeShort(0);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
        } else if (type == 144) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(buf.readUnsignedInt() * 1000L));
            short flags = buf.readUnsignedByte();
            position.setValid(true);
            position.setLatitude(ThinkRaceProtocolDecoder.convertCoordinate(buf.readUnsignedInt(), !BitUtil.check(flags, 0)));
            position.setLongitude(ThinkRaceProtocolDecoder.convertCoordinate(buf.readUnsignedInt(), !BitUtil.check(flags, 1)));
            position.setSpeed(buf.readUnsignedByte());
            position.setCourse(buf.readUnsignedByte());
            position.setNetwork(new Network(CellTower.fromLacCid(this.getConfig(), buf.readUnsignedShort(), buf.readUnsignedShort())));
            return position;
        }
        return null;
    }
}

