/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.util.URIUtil;
import org.traccar.config.Config;
import org.traccar.config.Keys;

public final class WebHelper {
    private WebHelper() {
    }

    public static String retrieveRemoteAddress(HttpServletRequest request) {
        if (request != null) {
            String remoteAddress = request.getHeader("X-FORWARDED-FOR");
            if (remoteAddress != null && !remoteAddress.isEmpty()) {
                int separatorIndex = remoteAddress.indexOf(",");
                if (separatorIndex > 0) {
                    return remoteAddress.substring(0, separatorIndex);
                }
                return remoteAddress;
            }
            return request.getRemoteAddr();
        }
        return null;
    }

    public static String retrieveWebUrl(Config config) {
        String address;
        if (config.hasKey(Keys.WEB_URL)) {
            return config.getString(Keys.WEB_URL).replaceAll("/$", "");
        }
        try {
            address = config.getString(Keys.WEB_ADDRESS, InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            address = "localhost";
        }
        return URIUtil.newURI((String)"http", (String)address, (int)config.getInteger(Keys.WEB_PORT));
    }
}

