/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.AmqpClient;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;

public class PositionForwarderAmqp
implements PositionForwarder {
    private final AmqpClient amqpClient;
    private final ObjectMapper objectMapper;

    public PositionForwarderAmqp(Config config, ObjectMapper objectMapper) {
        String connectionUrl = config.getString(Keys.FORWARD_URL);
        String exchange = config.getString(Keys.FORWARD_EXCHANGE);
        String topic = config.getString(Keys.FORWARD_TOPIC);
        this.amqpClient = new AmqpClient(connectionUrl, exchange, topic);
        this.objectMapper = objectMapper;
    }

    @Override
    public void forward(PositionData positionData, ResultHandler resultHandler) {
        try {
            String value = this.objectMapper.writeValueAsString((Object)positionData);
            this.amqpClient.publishMessage(value);
            resultHandler.onResult(true, null);
        }
        catch (IOException e) {
            resultHandler.onResult(false, e);
        }
    }
}

