/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.config;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.traccar.config.KeyType;

public abstract class ConfigKey<T> {
    private final String key;
    private final Set<KeyType> types = new HashSet<KeyType>();
    private final Class<T> valueClass;
    private final T defaultValue;

    ConfigKey(String key, List<KeyType> types, Class<T> valueClass, T defaultValue) {
        this.key = key;
        this.types.addAll(types);
        this.valueClass = valueClass;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public boolean hasType(KeyType type) {
        return this.types.contains((Object)type);
    }

    public Class<T> getValueClass() {
        return this.valueClass;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }
}

