/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.MultiDbConfig;
import redis.clients.jedis.UnifiedJedis;
import redis.clients.jedis.mcf.HealthCheckStrategy;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.ProbingPolicy;

public class PingStrategy
implements HealthCheckStrategy {
    private static final int MAX_HEALTH_CHECK_POOL_SIZE = 2;
    private final UnifiedJedis jedis;
    private final HealthCheckStrategy.Config config;
    public static final MultiDbConfig.StrategySupplier DEFAULT = PingStrategy::new;

    public PingStrategy(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig) {
        this(hostAndPort, jedisClientConfig, HealthCheckStrategy.Config.create());
    }

    public PingStrategy(HostAndPort hostAndPort, JedisClientConfig jedisClientConfig, HealthCheckStrategy.Config config) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(2);
        this.jedis = new JedisPooled(hostAndPort, jedisClientConfig, (GenericObjectPoolConfig<Connection>)poolConfig);
        this.config = config;
    }

    @Override
    public int getInterval() {
        return this.config.getInterval();
    }

    @Override
    public int getTimeout() {
        return this.config.getTimeout();
    }

    @Override
    public int getNumProbes() {
        return this.config.getNumProbes();
    }

    @Override
    public ProbingPolicy getPolicy() {
        return this.config.getPolicy();
    }

    @Override
    public int getDelayInBetweenProbes() {
        return this.config.getDelayInBetweenProbes();
    }

    @Override
    public HealthStatus doHealthCheck(Endpoint endpoint) {
        return "PONG".equals(this.jedis.ping()) ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
    }

    @Override
    public void close() {
        this.jedis.close();
    }
}

