/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.decorators.Decorators;
import redis.clients.jedis.Connection;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.mcf.MultiDbConnectionProvider;
import redis.clients.jedis.mcf.MultiDbFailoverBase;

@Experimental
public class MultiDbConnectionSupplier
extends MultiDbFailoverBase {
    public MultiDbConnectionSupplier(MultiDbConnectionProvider provider) {
        super(provider);
    }

    public Connection getConnection() {
        MultiDbConnectionProvider.Database database = this.provider.getDatabase();
        Decorators.DecorateSupplier supplier = Decorators.ofSupplier(() -> this.handleGetConnection(database));
        supplier.withRetry(database.getRetry());
        supplier.withCircuitBreaker(database.getCircuitBreaker());
        supplier.withFallback(this.provider.getFallbackExceptionList(), e -> this.handleDatabaseFailover(database));
        try {
            return (Connection)supplier.decorate().get();
        }
        catch (Exception e2) {
            if (database.getCircuitBreaker().getState() == CircuitBreaker.State.OPEN && this.isActiveDatabase(database)) {
                this.databaseFailover(database);
            }
            throw e2;
        }
    }

    private Connection handleGetConnection(MultiDbConnectionProvider.Database database) {
        Connection connection = database.getConnection();
        connection.ping();
        return connection;
    }

    private Connection handleDatabaseFailover(MultiDbConnectionProvider.Database database) {
        this.databaseFailover(database);
        return this.getConnection();
    }
}

