/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.ResourcePath;
import com.google.cloud.firestore.UserDataConverter;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;

class Order
implements Comparator<Value> {
    static final Order INSTANCE = new Order();
    private static final long MAX_INTEGER_TO_DOUBLE_PRECISION = 0x20000000000000L;

    static TypeOrder fromMapValue(MapValue mapValue) {
        switch (UserDataConverter.detectMapRepresentation(mapValue)) {
            case VECTOR_VALUE: {
                return TypeOrder.VECTOR;
            }
        }
        return TypeOrder.OBJECT;
    }

    private Order() {
    }

    @Override
    public int compare(@Nonnull Value left, @Nonnull Value right) {
        TypeOrder rightType;
        TypeOrder leftType = TypeOrder.fromValue(left);
        int typeComparison = leftType.compareTo(rightType = TypeOrder.fromValue(right));
        if (typeComparison != 0) {
            return typeComparison;
        }
        switch (leftType) {
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return Boolean.compare(left.getBooleanValue(), right.getBooleanValue());
            }
            case NUMBER: {
                return this.compareNumbers(left, right);
            }
            case TIMESTAMP: {
                return Order.compareTimestamps(left, right);
            }
            case STRING: {
                return Order.compareUtf8Strings(left.getStringValue(), right.getStringValue());
            }
            case BLOB: {
                return this.compareBlobs(left, right);
            }
            case REF: {
                return this.compareResourcePaths(left, right);
            }
            case GEO_POINT: {
                return Order.compareGeoPoints(left, right);
            }
            case ARRAY: {
                return this.compareArrays(left.getArrayValue().getValuesList(), right.getArrayValue().getValuesList());
            }
            case OBJECT: {
                return this.compareObjects(left, right);
            }
            case VECTOR: {
                return this.compareVectors(left, right);
            }
        }
        throw new IllegalArgumentException("Cannot compare " + leftType);
    }

    public static int compareUtf8Strings(String left, String right) {
        if (left == right) {
            return 0;
        }
        int length = Math.min(left.length(), right.length());
        for (int i = 0; i < length; ++i) {
            char rightChar;
            char leftChar = left.charAt(i);
            if (leftChar == (rightChar = right.charAt(i))) continue;
            return Character.isSurrogate(leftChar) == Character.isSurrogate(rightChar) ? Character.compare(leftChar, rightChar) : (Character.isSurrogate(leftChar) ? 1 : -1);
        }
        return Integer.compare(left.length(), right.length());
    }

    private int compareBlobs(Value left, Value right) {
        ByteString leftBytes = left.getBytesValue();
        ByteString rightBytes = right.getBytesValue();
        return Order.compareByteStrings(leftBytes, rightBytes);
    }

    static int compareByteStrings(ByteString leftBytes, ByteString rightBytes) {
        int size = Math.min(leftBytes.size(), rightBytes.size());
        for (int i = 0; i < size; ++i) {
            int otherByte;
            int thisByte = leftBytes.byteAt(i) & 0xFF;
            if (thisByte < (otherByte = rightBytes.byteAt(i) & 0xFF)) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return Integer.compare(leftBytes.size(), rightBytes.size());
    }

    private static int compareTimestamps(Value left, Value right) {
        int cmp = Long.compare(left.getTimestampValue().getSeconds(), right.getTimestampValue().getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.compare(left.getTimestampValue().getNanos(), right.getTimestampValue().getNanos());
    }

    private static int compareGeoPoints(Value left, Value right) {
        int cmp = Double.compare(left.getGeoPointValue().getLatitude(), right.getGeoPointValue().getLatitude());
        if (cmp != 0) {
            return cmp;
        }
        return Double.compare(left.getGeoPointValue().getLongitude(), right.getGeoPointValue().getLongitude());
    }

    private int compareResourcePaths(Value left, Value right) {
        ResourcePath leftPath = ResourcePath.create(left.getReferenceValue());
        ResourcePath rightPath = ResourcePath.create(right.getReferenceValue());
        return leftPath.compareTo(rightPath);
    }

    public int compareArrays(List<Value> left, List<Value> right) {
        int minLength = Math.min(left.size(), right.size());
        for (int i = 0; i < minLength; ++i) {
            int cmp = this.compare(left.get(i), right.get(i));
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(left.size(), right.size());
    }

    private int compareObjects(Value left, Value right) {
        TreeMap leftMap = new TreeMap(left.getMapValue().getFieldsMap());
        TreeMap rightMap = new TreeMap(right.getMapValue().getFieldsMap());
        Iterator leftIterator = leftMap.entrySet().iterator();
        Iterator rightIterator = rightMap.entrySet().iterator();
        while (leftIterator.hasNext() && rightIterator.hasNext()) {
            Map.Entry leftEntry = leftIterator.next();
            Map.Entry rightEntry = rightIterator.next();
            int keyCompare = Order.compareUtf8Strings((String)leftEntry.getKey(), (String)rightEntry.getKey());
            if (keyCompare != 0) {
                return keyCompare;
            }
            int valueCompare = this.compare((Value)leftEntry.getValue(), (Value)rightEntry.getValue());
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        return Boolean.compare(leftIterator.hasNext(), rightIterator.hasNext());
    }

    private int compareVectors(Value left, Value right) {
        Value leftValueField = left.getMapValue().getFieldsOrDefault("value", null);
        Value rightValueField = right.getMapValue().getFieldsOrDefault("value", null);
        List leftArray = leftValueField != null ? leftValueField.getArrayValue().getValuesList() : Collections.emptyList();
        List rightArray = rightValueField != null ? rightValueField.getArrayValue().getValuesList() : Collections.emptyList();
        Integer lengthCompare = Long.compare(leftArray.size(), rightArray.size());
        if (lengthCompare != 0) {
            return lengthCompare;
        }
        return this.compareArrays(leftArray, rightArray);
    }

    private int compareNumbers(Value left, Value right) {
        if (this.isNaN(left)) {
            return this.isNaN(right) ? 0 : -1;
        }
        if (this.isNaN(right)) {
            return 1;
        }
        if (left.getValueTypeCase() == Value.ValueTypeCase.DOUBLE_VALUE) {
            if (right.getValueTypeCase() == Value.ValueTypeCase.DOUBLE_VALUE) {
                return this.compareDoubles(left.getDoubleValue(), right.getDoubleValue());
            }
            return this.compareDoubleAndLong(left.getDoubleValue(), right.getIntegerValue());
        }
        if (right.getValueTypeCase() == Value.ValueTypeCase.INTEGER_VALUE) {
            return Long.compare(left.getIntegerValue(), right.getIntegerValue());
        }
        return -this.compareDoubleAndLong(right.getDoubleValue(), left.getIntegerValue());
    }

    private boolean isNaN(Value value) {
        return value.hasDoubleValue() && Double.isNaN(value.getDoubleValue());
    }

    private int compareDoubles(double left, double right) {
        return Double.compare(left == -0.0 ? 0.0 : left, right == -0.0 ? 0.0 : right);
    }

    private int compareDoubleAndLong(double doubleValue, long longValue) {
        if (Math.abs(longValue) <= 0x20000000000000L) {
            return this.compareDoubles(doubleValue, longValue);
        }
        if (doubleValue < 9.223372036854776E18 && doubleValue >= -9.223372036854776E18) {
            return Long.compare((long)doubleValue, longValue);
        }
        return doubleValue < 0.0 ? -1 : 1;
    }

    static enum TypeOrder implements Comparable<TypeOrder>
    {
        NULL,
        BOOLEAN,
        NUMBER,
        TIMESTAMP,
        STRING,
        BLOB,
        REF,
        GEO_POINT,
        ARRAY,
        VECTOR,
        OBJECT;


        static TypeOrder fromValue(Value value) {
            switch (value.getValueTypeCase()) {
                case NULL_VALUE: {
                    return NULL;
                }
                case BOOLEAN_VALUE: {
                    return BOOLEAN;
                }
                case INTEGER_VALUE: {
                    return NUMBER;
                }
                case DOUBLE_VALUE: {
                    return NUMBER;
                }
                case TIMESTAMP_VALUE: {
                    return TIMESTAMP;
                }
                case STRING_VALUE: {
                    return STRING;
                }
                case BYTES_VALUE: {
                    return BLOB;
                }
                case REFERENCE_VALUE: {
                    return REF;
                }
                case GEO_POINT_VALUE: {
                    return GEO_POINT;
                }
                case ARRAY_VALUE: {
                    return ARRAY;
                }
                case MAP_VALUE: {
                    return Order.fromMapValue(value.getMapValue());
                }
            }
            throw new IllegalArgumentException("Could not detect value type for " + value);
        }
    }
}

