/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.concurrent.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Shrinkable;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public interface MapOps<K, V, CC extends MapOps<Object, Object, CC, ?>, C extends MapOps<K, V, CC, C>>
extends scala.collection.MapOps<K, V, CC, C>,
Cloneable<C>,
Builder<Tuple2<K, V>, C>,
Shrinkable<K>,
Object {
    public static void $init$(MapOps $this) {
    }

    public static MapOps result$(MapOps $this) {
        return $this.result();
    }

    @Override
    default public C result() {
        return (C)((MapOps)this.coll());
    }

    public static MapOps $minus$(MapOps $this, Object key) {
        return $this.$minus(key);
    }

    default public C $minus(K key) {
        return (C)((MapOps)this.clone().$minus$eq(key));
    }

    public static MapOps $minus$(MapOps $this, Object key1, Object key2, Seq keys) {
        return $this.$minus(key1, key2, keys);
    }

    default public C $minus(K key1, K key2, Seq<K> keys) {
        return (C)((MapOps)this.clone().$minus$eq(key1).$minus$eq(key2).$minus$minus$eq(keys));
    }

    public static Option put$(MapOps $this, Object key, Object value) {
        return $this.put(key, value);
    }

    default public Option<V> put(K key, V value) {
        Option r = this.get(key);
        this.update(key, value);
        return r;
    }

    public static void update$(MapOps $this, Object key, Object value) {
        $this.update(key, value);
    }

    default public void update(K key, V value) {
        ((Growable)this.coll()).$plus$eq(Tuple2$.MODULE$.apply(key, value));
    }

    public static Option updateWith$(MapOps $this, Object key, Function1 remappingFunction) {
        return $this.updateWith(key, remappingFunction);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public Option<V> updateWith(K key, Function1<Option<V>, Option<V>> remappingFunction) {
        Serializable serializable;
        Option previousValue = this.get(key);
        Option<V> nextValue = remappingFunction.apply(previousValue);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(previousValue, nextValue);
        Option option = tuple2._1();
        Option<V> option2 = tuple2._2();
        if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
            serializable = BoxedUnit.UNIT;
            return nextValue;
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            if (None$.MODULE$.equals(option2)) {
                serializable = this.remove(key);
                return nextValue;
            }
        }
        if (!(option2 instanceof Some)) throw new MatchError(tuple2);
        Some some = (Some)option2;
        Object v = some.value();
        this.update(key, v);
        serializable = BoxedUnit.UNIT;
        return nextValue;
    }

    public static Object getOrElseUpdate$(MapOps $this, Object key, Function0 defaultValue) {
        return $this.getOrElseUpdate(key, defaultValue);
    }

    default public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        Option option = this.get(key);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object v = some.value();
            return (V)v;
        }
        if (None$.MODULE$.equals(option)) {
            V d = defaultValue.apply();
            this.update(key, d);
            return d;
        }
        throw new MatchError(option);
    }

    public static Option remove$(MapOps $this, Object key) {
        return $this.remove(key);
    }

    default public Option<V> remove(K key) {
        Option r = this.get(key);
        if (r.isDefined()) {
            this.$minus$eq(key);
        }
        return r;
    }

    public static void clear$(MapOps $this) {
        $this.clear();
    }

    @Override
    default public void clear() {
        this.keysIterator().foreach((Function1<Object, MapOps> & Serializable)elem -> (MapOps)this.$minus$eq(elem));
    }

    public static MapOps clone$(MapOps $this) {
        return $this.clone();
    }

    @Override
    default public C clone() {
        return (C)((MapOps)((Growable)this.empty()).$plus$plus$eq(this));
    }

    public static MapOps retain$(MapOps $this, Function2 p) {
        return $this.retain(p);
    }

    default public MapOps<K, V, CC, C> retain(Function2<K, V, Object> p) {
        return this.filterInPlace(p);
    }

    public static MapOps filterInPlace$(MapOps $this, Function2 p) {
        return $this.filterInPlace(p);
    }

    default public MapOps<K, V, CC, C> filterInPlace(Function2<K, V, Object> p) {
        if (!this.isEmpty()) {
            MapOps mapOps = this;
            if (mapOps instanceof Map) {
                Map map;
                Map tm = map = (Map)mapOps;
                tm.filterInPlaceImpl(p);
            } else {
                Object[] array = (Object[])this.toArray(ClassTag$.MODULE$.Any());
                int arrayLength = array.length;
                for (int i = 0; i < arrayLength; ++i) {
                    Object v;
                    Tuple2 tuple2 = (Tuple2)array[i];
                    Tuple2 $1$ = tuple2;
                    Tuple2 tuple22 = $1$;
                    Object k = tuple22._1();
                    if (BoxesRunTime.unboxToBoolean(p.apply(k, v = tuple22._2()))) continue;
                    this.$minus$eq(k);
                }
            }
        }
        return this;
    }

    public static MapOps transform$(MapOps $this, Function2 f) {
        return $this.transform(f);
    }

    default public MapOps<K, V, CC, C> transform(Function2<K, V, V> f) {
        return this.mapValuesInPlace(f);
    }

    public static MapOps mapValuesInPlace$(MapOps $this, Function2 f) {
        return $this.mapValuesInPlace(f);
    }

    default public MapOps<K, V, CC, C> mapValuesInPlace(Function2<K, V, V> f) {
        if (!this.isEmpty()) {
            MapOps mapOps = this;
            if (mapOps instanceof HashMap) {
                HashMap hashMap;
                HashMap hm = hashMap = (HashMap)mapOps;
                hm.mapValuesInPlaceImpl(f);
            } else if (mapOps instanceof Map) {
                Map map;
                Map tm = map = (Map)mapOps;
                tm.mapValuesInPlaceImpl(f);
            } else {
                Object[] array = (Object[])this.toArray(ClassTag$.MODULE$.Any());
                int arrayLength = array.length;
                for (int i = 0; i < arrayLength; ++i) {
                    Tuple2 tuple2;
                    Tuple2 $3$;
                    Tuple2 tuple22 = $3$ = (tuple2 = (Tuple2)array[i]);
                    Object k = tuple22._1();
                    Object v = tuple22._2();
                    this.update(k, f.apply(k, v));
                }
            }
        }
        return this;
    }

    public static MapOps updated$(MapOps $this, Object key, Object value) {
        return $this.updated(key, value);
    }

    default public <V1> CC updated(K key, V1 value) {
        return (CC)((MapOps)this.clone().addOne(Tuple2$.MODULE$.apply(key, value)));
    }

    public static int knownSize$(MapOps $this) {
        return $this.knownSize();
    }

    @Override
    default public int knownSize() {
        return IterableOnce.knownSize$(this);
    }
}

