# Changelog

## 0.4.11 (2024-04-11)

- Clean up some `ctest` internals
- Increase the recursion limit to fix building on docs.rs

<!-- FIXME(ctest): some versions are missing -->

## 0.4.7 (2023-06-10)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 4 commits contributed to the release over the course of 7 calendar days.
 - 35 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #53 from JohnTitor/forgetting_copy_types ([`4c5c32f`](https://github.com/JohnTitor/ctest2/commit/4c5c32fcde07c3ccaed61f42dc434f0f90682a3f))
    - Address `forgetting_copy_types` lint ([`adcc889`](https://github.com/JohnTitor/ctest2/commit/adcc889d30550c92e135d74820477f022ddb5bbd))
    - Merge pull request #52 from samkearney/add-x86-qnx-support ([`a40b8af`](https://github.com/JohnTitor/ctest2/commit/a40b8afcbd55fbca30911f07b406157c848cdaeb))
    - Add a config default for QNX 7.0 ([`2af1537`](https://github.com/JohnTitor/ctest2/commit/2af153709b41386aa664ef78d1d9acb35455880b))
</details>


## 0.4.6 (2023-05-06)

### Bug Fixes

 - <csr-id-7b3154cca43bb0f90a0dd7a6206559f190d625b9/> don't use periods in target names
   See https://github.com/rust-lang/rust/pull/104523

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 6 commits contributed to the release over the course of 150 calendar days.
 - 167 days passed between releases.
 - 1 commit was understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #32 from zhaixiaojuan/master ([`b26e82d`](https://github.com/JohnTitor/ctest2/commit/b26e82da33d004184f251a61ae1eb3de3cf75b6c))
    - Add loongarch64 support ([`64cc233`](https://github.com/JohnTitor/ctest2/commit/64cc2337bc38b4654480a9c0adabaf67e9f6817f))
    - Merge pull request #49 from Amanieu/ohos ([`e6b5909`](https://github.com/JohnTitor/ctest2/commit/e6b59094cd18ec6e044f3d2564044fde04c21cb7))
    - Add support for OpenHarmony ([`1d1af22`](https://github.com/JohnTitor/ctest2/commit/1d1af22b80cb4812dbb65cedc063f234603c7553))
    - Merge pull request #47 from flba-eb/remove_period_in_target_name ([`dbc023a`](https://github.com/JohnTitor/ctest2/commit/dbc023a7fc538eb86a62a9d282a7946a4c7312cd))
    - Don't use periods in target names ([`7b3154c`](https://github.com/JohnTitor/ctest2/commit/7b3154cca43bb0f90a0dd7a6206559f190d625b9))
</details>

## 0.4.5 (2022-11-19)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 12 commits contributed to the release over the course of 133 calendar days.
 - 190 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #46 from flba-eb/add_nto_support ([`6287035`](https://github.com/JohnTitor/ctest2/commit/6287035dd465536f7799516f6954bc454d1d0f17))
    - Fix QNX/nto support of 7.1 ([`494273a`](https://github.com/JohnTitor/ctest2/commit/494273ae59a776f8bf771778232290c6fa3e3116))
    - Merge pull request #41 from wesleywiser/master ([`f419830`](https://github.com/JohnTitor/ctest2/commit/f419830d09cefb31e2b076039b47b925e53ce6b9))
    - Merge pull request #42 from flba-eb/add_qnx_support ([`0db6046`](https://github.com/JohnTitor/ctest2/commit/0db6046dd6c5cf816d8cdc5aec5415e535ea4db9))
    - Add basic QNX support ([`3d3a0b1`](https://github.com/JohnTitor/ctest2/commit/3d3a0b19a7312f6557a32b80f68981d2092aa198))
    - Merge pull request #44 from JohnTitor/fix-typos ([`2c609e2`](https://github.com/JohnTitor/ctest2/commit/2c609e285c16fdc8dde02509c82786c4c48a959f))
    - Fix some typos ([`1fa9856`](https://github.com/JohnTitor/ctest2/commit/1fa985693300df5597b7e333f293e4660dd02593))
    - Swap size and value args in roundtrip tests ([`ed9b5d6`](https://github.com/JohnTitor/ctest2/commit/ed9b5d675545dcafe5f13f95f2dada2812932cf2))
    - Merge pull request #39 from joshtriplett/code-block-terminators ([`ce8fc54`](https://github.com/JohnTitor/ctest2/commit/ce8fc54e5f1b0a0fc2356601acdc8cdc56a22b76))
    - Fix missing code block terminators in docstrings ([`3ea3965`](https://github.com/JohnTitor/ctest2/commit/3ea396523425e5f3948146bde869f5d0ccd0e2ca))
    - Merge pull request #37 from flba-eb/master ([`ec09955`](https://github.com/JohnTitor/ctest2/commit/ec09955c349bb6a999ecf1ce4492d7284c024b98))
    - Print out errors to stderr ([`aacc9e6`](https://github.com/JohnTitor/ctest2/commit/aacc9e64d2a372e74d7d8e9066881645bb444827))
</details>

## v0.4.4 (2022-05-12)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 4 commits contributed to the release over the course of 15 calendar days.
 - 164 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #35 from JohnTitor/fix-offset-of-again ([`6d2dd7d`](https://github.com/JohnTitor/ctest2/commit/6d2dd7dbfda82207ba151ab277af38cae585cf45))
    - Remove the use of `mem::zeroed()` on generated code ([`e8b215c`](https://github.com/JohnTitor/ctest2/commit/e8b215c54a6c2784e475790a0c1bda18cab4169c))
    - Merge pull request #33 from jessicah/cpp-linkage ([`2054b80`](https://github.com/JohnTitor/ctest2/commit/2054b803d038916abc834856cbe177ffa18e8455))
    - Specify linkage for `__test_fn...()`. ([`5684414`](https://github.com/JohnTitor/ctest2/commit/5684414735b58683451e8a364c7ede94f101969e))
</details>

## v0.4.3 (2021-11-28)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release.
 - 42 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #30 from GuillaumeGomez/long-double ([`1769ea1`](https://github.com/JohnTitor/ctest2/commit/1769ea1772db11147b8cfcc1c0b9095865d2d1de))
    - Add support for long double ([`76bcbd5`](https://github.com/JohnTitor/ctest2/commit/76bcbd5fa20e86d7d39ecf8300744b4e008f5f18))
</details>

## v0.4.2 (2021-10-16)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release.
 - 146 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #28 from GuillaumeGomez/subtract ([`aaf6759`](https://github.com/JohnTitor/ctest2/commit/aaf6759f061a398b59bd2abca59ce8ba7414e3d4))
    - Allow to subtract in constants ([`17df391`](https://github.com/JohnTitor/ctest2/commit/17df3916cd84b0ba626b438e18eb3812ba7340ec))
</details>

## v0.4.1 (2021-05-23)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 4 commits contributed to the release.
 - 115 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #25 from JohnTitor/fix-unaligned-references ([`aab0ed6`](https://github.com/JohnTitor/ctest2/commit/aab0ed632207eb984b33d8ff9585d504ff22b9d7))
    - Fix `unaligned_references` warning ([`58fe3e5`](https://github.com/JohnTitor/ctest2/commit/58fe3e5dc1fec08d067cc41149bb7d75048077eb))
    - Merge pull request #24 from JohnTitor/fix-dereference-null-ptr ([`64fc427`](https://github.com/JohnTitor/ctest2/commit/64fc4270a50427f322351543fbf6f0fc151586d6))
    - Fix the `deref_nullptr` warning ([`5d5b425`](https://github.com/JohnTitor/ctest2/commit/5d5b425979b49e37d4ee5629caf2723b10886679))
</details>

## v0.4.0 (2021-01-28)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 7 commits contributed to the release over the course of 159 calendar days.
 - 240 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #20 from nielx/master ([`f2842c7`](https://github.com/JohnTitor/ctest2/commit/f2842c73a6c04476701a88ad1edc8b0e943634b8))
    - Add support for the Haiku target ([`193a72f`](https://github.com/JohnTitor/ctest2/commit/193a72fb5beb8008bb2256709bac8c240685d079))
    - Merge pull request #16 from JohnTitor/edition-2018 ([`82ef3da`](https://github.com/JohnTitor/ctest2/commit/82ef3da023da04a5f9ed401e3671a881b8db6d07))
    - Fix Clippy warnings ([`4aafd94`](https://github.com/JohnTitor/ctest2/commit/4aafd946470e016fff02af26bb6dba2c49d1c683))
    - Update crate to edition 2018 ([`1de5a4c`](https://github.com/JohnTitor/ctest2/commit/1de5a4cac5a33921135a0e7503240299bcc9f295))
    - Merge pull request #13 from JohnTitor/use-or ([`bb83079`](https://github.com/JohnTitor/ctest2/commit/bb830791b08edd5589874f70cb3bab4cf551e307))
    - Use `OR` keyword instead of deprecated `/` ([`76dab1c`](https://github.com/JohnTitor/ctest2/commit/76dab1cef5d4dbb81147f9ea3a45b0b2c3ce7354))
</details>

## v0.3.0 (2020-06-01)

<csr-id-0bbbc85fbd211f33815b39d9f472cf22d088846f/>

### Other

 - <csr-id-0bbbc85fbd211f33815b39d9f472cf22d088846f/> :uninitialized is deprecated

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 45 commits contributed to the release over the course of 551 calendar days.
 - 553 days passed between releases.
 - 1 commit was understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #11 from JohnTitor/garando ([`fc6621f`](https://github.com/JohnTitor/ctest2/commit/fc6621f5199a45108af5035eda86996ef88aaeaf))
    - Use garando_syntax ([`732c7b5`](https://github.com/JohnTitor/ctest2/commit/732c7b531073a57f186321c7799d3b4cda639856))
    - Merge pull request #8 from JohnTitor/ctest2 ([`1432332`](https://github.com/JohnTitor/ctest2/commit/1432332bdeda9e64c519ce72734170af2bb61d96))
    - Rename to ctest2 ([`bdadd0b`](https://github.com/JohnTitor/ctest2/commit/bdadd0b4c0c6db84abcb856cfa6267ecdfca8bf9))
    - Merge pull request #5 from JohnTitor/riscv64gc ([`8ac57fb`](https://github.com/JohnTitor/ctest2/commit/8ac57fb0dfb90b12f41d598449adc80dd7a00156))
    - Add `riscv64gc` arch support ([`fd7bfb2`](https://github.com/JohnTitor/ctest2/commit/fd7bfb29820fcbe6457c97cb4ae761e6fb02d56e))
    - Merge pull request #4 from JohnTitor/maybe-uninit ([`4787a04`](https://github.com/JohnTitor/ctest2/commit/4787a04dacf80ea7d59e89d2414daef9cea5f4d8))
    - Use MaybeUninit instead of uninitialized ([`f8ada39`](https://github.com/JohnTitor/ctest2/commit/f8ada39ce4e8c596650bcaa184d83fae488f2b2c))
    - Merge pull request #2 from pfmooney/target-error ([`466af76`](https://github.com/JohnTitor/ctest2/commit/466af761070a82f97ccec6c6f2d36ab84462eb6f))
    - Merge pull request #1 from pfmooney/illumos-target ([`3c1bb06`](https://github.com/JohnTitor/ctest2/commit/3c1bb06272e4797a8d1ed86c08a0008c88f0eb7d))
    - Fix typo in "unknown target" error message ([`04bac2c`](https://github.com/JohnTitor/ctest2/commit/04bac2c7c25bbeea0f05b78e11c39c904d4a2005))
    - Add illumos target ([`1b4efff`](https://github.com/JohnTitor/ctest2/commit/1b4efff47d23624bbad42a5741e4cc4476560e8e))
    - Add supporting for vxWorks ([`570e058`](https://github.com/JohnTitor/ctest2/commit/570e0584f0dc4aeab6ff4e9c07190c346a45beeb))
    - Improve error output ([`cf096e1`](https://github.com/JohnTitor/ctest2/commit/cf096e1a0f24072c8016dd649f1349a6785aa15b))
    - Improve errors of roundtrip tests ([`ddf07ea`](https://github.com/JohnTitor/ctest2/commit/ddf07ea5759f9605da968c391007117847553a0a))
    - Fix roundtrip tests for structs larger than 252 bytes ([`2d3be56`](https://github.com/JohnTitor/ctest2/commit/2d3be569b07f413a7639419d84391d1d04f4d6fe))
    - Merge pull request #78 from gnzlbg/unknown_warning ([`e9b8697`](https://github.com/JohnTitor/ctest2/commit/e9b8697b4eceae69712dda6e4c55c9c42971b887))
    - :uninitialized is deprecated ([`0bbbc85`](https://github.com/JohnTitor/ctest2/commit/0bbbc85fbd211f33815b39d9f472cf22d088846f))
    - Avoid errors on unknown warnings ([`57da2c3`](https://github.com/JohnTitor/ctest2/commit/57da2c3b2e74a2ff135d0369647c1fe2a3b3bf96))
    - Fix alignment computation once and for all ([`c870733`](https://github.com/JohnTitor/ctest2/commit/c87073322872c61371997666752e159f5e582d11))
    - Use a custom alignof implementation ([`0880937`](https://github.com/JohnTitor/ctest2/commit/0880937f3550c3f88ed6f5da237144241e9aed9c))
    - Temporarily remove MaybeUninit ([`f8c43dc`](https://github.com/JohnTitor/ctest2/commit/f8c43dce0f71758c8c8467b44217beca582714b7))
    - Workaround mingw being broken: rust-lang/47048 ([`79dc2a0`](https://github.com/JohnTitor/ctest2/commit/79dc2a0ec63a1fc991457cdafda8e9a42abb238a))
    - Use MaybeUninit to store invalid representations and only check non-padding bytes ([`5daf96b`](https://github.com/JohnTitor/ctest2/commit/5daf96b3597ef89993e402021be98f0ad58fb40c))
    - Silence spurous warnings on MSVC ([`ffe2573`](https://github.com/JohnTitor/ctest2/commit/ffe25732319b983966d3886c795494c053eac014))
    - Add ABI roundtrip test ([`5ab52f3`](https://github.com/JohnTitor/ctest2/commit/5ab52f3b8f6086f23b48ae176fd42d8dd85c6f5d))
    - Add support for transparent and packed(N) types ([`6e1f066`](https://github.com/JohnTitor/ctest2/commit/6e1f066e673ef12576554016de768ae37d552e46))
    - Add a repr(packed(N)) test ([`2460886`](https://github.com/JohnTitor/ctest2/commit/24608866b5543787dddf5bdb78a1097610b51e8d))
    - Silence another msvc warning ([`99e89ab`](https://github.com/JohnTitor/ctest2/commit/99e89abd8259f836300ea4b1de3466058b6e7a6f))
    - Allow taking references to packed struct fields in MSVC ([`6f1a656`](https://github.com/JohnTitor/ctest2/commit/6f1a656c1eb2c0fb864139f75b00fa308382f634))
    - Add redox target ([`835506d`](https://github.com/JohnTitor/ctest2/commit/835506db973410dfed4385be127eea1d9dcd0bea))
    - Fix build by running rustfmt ([`b645216`](https://github.com/JohnTitor/ctest2/commit/b64521631710dc950ffde055973fc92c02a3b120))
    - Add a way to specify that a function argument is an array in C ([`f551ca7`](https://github.com/JohnTitor/ctest2/commit/f551ca713949dd3c70a22bea4c7c04fc06c759ce))
    - Improve support for arrays ([`fb76cbc`](https://github.com/JohnTitor/ctest2/commit/fb76cbc2bdaed2d0efc6ffada50a7c8003fd3ee6))
    - Clippy ([`cc5690a`](https://github.com/JohnTitor/ctest2/commit/cc5690a180a1f713d6cf2f587eb06eebe8a728eb))
    - Formatting ([`5dd2909`](https://github.com/JohnTitor/ctest2/commit/5dd2909a2801c65e90b4d781bce87f1dc7e238fb))
    - Add support for verifying volatile pointers ([`a349575`](https://github.com/JohnTitor/ctest2/commit/a3495758a023f0a8f53dab22d8d2029ce3aaf6f1))
    - Add wasi definitions ([`c908271`](https://github.com/JohnTitor/ctest2/commit/c9082716c4438c9b71438ec8da8f604f53695bd2))
    - Add an option to print skipped items ([`9b8a31e`](https://github.com/JohnTitor/ctest2/commit/9b8a31e78884255476a37b3de7c504b8427ab579))
    - Check that the tests do not emit warnings ([`af6d9a3`](https://github.com/JohnTitor/ctest2/commit/af6d9a3edc798336dc7cf9e10e24cfc6c0d07de1))
    - Merge pull request #58 from gnzlbg/const_name ([`8111142`](https://github.com/JohnTitor/ctest2/commit/8111142a7226e20821e73b4685cb5f86b7b39932))
    - Fix clippy and formatting ([`3548657`](https://github.com/JohnTitor/ctest2/commit/3548657cd38e0b947ca2bc62cff201ded098fa70))
    - Add C++ support ([`413f843`](https://github.com/JohnTitor/ctest2/commit/413f8439166979e8884065dee0ec157036e08820))
    - Add const_cname API to map Rust const names to C names ([`75722df`](https://github.com/JohnTitor/ctest2/commit/75722dfbceb8d5cd3a1aa7135ec2aa5282598869))
    - Add support for packed structs ([`3e2ac3a`](https://github.com/JohnTitor/ctest2/commit/3e2ac3ab9c785866c6e4eb37df903d3defd38d17))
</details>

## v0.2.7 (2018-11-25)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 5 commits contributed to the release over the course of 27 calendar days.
 - 27 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Fix generates tests with C function conflict ([`96ca3fa`](https://github.com/JohnTitor/ctest2/commit/96ca3fa81605aa9a7d55a74f64c6b2df9af9ded1))
    - Support statics of Option<fn> types ([`ee2fd33`](https://github.com/JohnTitor/ctest2/commit/ee2fd33d94fd4f7640b4b989e1f3b9b876cdbbc3))
    - Support non-mut statics with Option<&T> ([`31cae7d`](https://github.com/JohnTitor/ctest2/commit/31cae7d94f86bc90015a25a4c28c4cf499b42ae6))
    - Fix clippy issues ([`e17d4ae`](https://github.com/JohnTitor/ctest2/commit/e17d4ae67c3d9b380053b20644b701bcf67dec18))
    - Re-format ([`eab052c`](https://github.com/JohnTitor/ctest2/commit/eab052cb32b6c7cfbaef3bfc48a998a26a98693a))
</details>

## v0.2.4 (2018-10-29)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 3 commits contributed to the release over the course of 8 calendar days.
 - 9 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #46 from gnzlbg/fb2 ([`dae2780`](https://github.com/JohnTitor/ctest2/commit/dae27809d8f2abf692d8d6b8a7885b2ab9ff77b4))
    - Add support for extern static references and optional references ([`07c96c6`](https://github.com/JohnTitor/ctest2/commit/07c96c674233970eaf1e8674039b07b4c8a9645b))
    - Merge pull request #43 from johnschug/skip-sign ([`9480ee3`](https://github.com/JohnTitor/ctest2/commit/9480ee376ef3b24567ca0b208b7e9b9faa19f82b))
</details>

## v0.2.3 (2018-10-20)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 6 commits contributed to the release over the course of 3 calendar days.
 - 37 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #42 from gnzlbg/arrs ([`f0fea68`](https://github.com/JohnTitor/ctest2/commit/f0fea68bf69c27e5e08b5a10528387ba367fa254))
    - Skip signedness checks for non-integer type aliases ([`2099f61`](https://github.com/JohnTitor/ctest2/commit/2099f6179f476aef903ca6a3131e043e75c06cec))
    - Add support for arrays in extern statics ([`d389610`](https://github.com/JohnTitor/ctest2/commit/d389610b9ece689a2b3e602eacb9cd19af8af50f))
    - Merge pull request #39 from gnzlbg/rs2c ([`f8bd332`](https://github.com/JohnTitor/ctest2/commit/f8bd33266921636ce99c1026ddb429095b896921))
    - Add support for nested functions ([`30f5187`](https://github.com/JohnTitor/ctest2/commit/30f5187a6a456942015f6361bae045ff06736dca))
    - Minimal support for fn types in extern statics ([`9375d57`](https://github.com/JohnTitor/ctest2/commit/9375d57cf2151069306ea04222bcad2d61862e9c))
</details>

## v0.2.2 (2018-09-12)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release.
 - 8 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #37 from tbu-/pr_test_statics2 ([`5daab1d`](https://github.com/JohnTitor/ctest2/commit/5daab1daf0a361f81f83d98b7def856ff289b01b))
    - Revert bump in the minimum supported Rust version ([`92bc00e`](https://github.com/JohnTitor/ctest2/commit/92bc00eecc1b8725ecaa318df860664a91846fe4))
</details>

## v0.2.1 (2018-09-04)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 2 commits contributed to the release over the course of 22 calendar days.
 - 22 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Add static testing ([`f665acc`](https://github.com/JohnTitor/ctest2/commit/f665accfdc52b3f887cc59511aaf2c3009b902b1))
    - Merge pull request #35 from gnzlbg/doc0 ([`e8cd0c2`](https://github.com/JohnTitor/ctest2/commit/e8cd0c2f341fe5211a9a25f646df0a3352a8eec8))
</details>

## v0.2.0 (2018-08-12)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 9 commits contributed to the release over the course of 190 calendar days.
 - 192 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Improve docs of cfg method ([`e9355e7`](https://github.com/JohnTitor/ctest2/commit/e9355e738e3e25c5b51114f9bc7974da83040c6c))
    - Merge pull request #34 from afdw/master ([`bf780a0`](https://github.com/JohnTitor/ctest2/commit/bf780a0e62caf4fb4747bd683713864b444bd6fb))
    - Add support for unions without typedefs ([`8078823`](https://github.com/JohnTitor/ctest2/commit/80788238ecaca2a610efea3f5c46ea9f23f88121))
    - Merge pull request #29 from glandium/target_endian ([`94815ca`](https://github.com/JohnTitor/ctest2/commit/94815cadb00ab7bcee8b2f9b903c4db7f14c6fa1))
    - Add target_endian to the set of #[cfg()] items that are considered. ([`25b5b64`](https://github.com/JohnTitor/ctest2/commit/25b5b64e36147aab36a83cb1ffd5432c09a317ce))
    - Merge pull request #28 from gnzlbg/deprecated ([`954f493`](https://github.com/JohnTitor/ctest2/commit/954f493d482a0873866ba335bee75ce2936e5415))
    - Allow deprecated declarations on non-msvc targets ([`a24ccd2`](https://github.com/JohnTitor/ctest2/commit/a24ccd2ad9995915f6be99dcf6e548f2bdfafe14))
    - Merge pull request #27 from gnzlbg/fix_bug ([`d3a5248`](https://github.com/JohnTitor/ctest2/commit/d3a5248c49ced9e5d42ebd74ee494db2988e7bad))
    - Panic on non-repr(C) structs only if the struct should not be skipped ([`c79cfd9`](https://github.com/JohnTitor/ctest2/commit/c79cfd9d02aa6e5f6026e79df8b47bcdd34ec597))
</details>

## v0.1.7 (2018-02-01)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 5 commits contributed to the release over the course of 106 calendar days.
 - 134 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Fix checking structs with `#[derive]` ([`b590c29`](https://github.com/JohnTitor/ctest2/commit/b590c2958b010d0a2512b5b81abccd8879f65604))
    - Merge pull request #25 from bgermann/master ([`29d33e2`](https://github.com/JohnTitor/ctest2/commit/29d33e26d8f1297736c3716f4f2495dd068849ef))
    - Solaris support ([`8182b0c`](https://github.com/JohnTitor/ctest2/commit/8182b0cb0e73cc5b314886adeed9ebdf32d6e769))
    - Merge pull request #22 from malbarbo/x32 ([`621f64e`](https://github.com/JohnTitor/ctest2/commit/621f64e78e25e71aca65f023591508dec188ae92))
    - Add support for linux x32 ([`8739c4b`](https://github.com/JohnTitor/ctest2/commit/8739c4bfe720e994184a95c7ebec773183f255f9))
</details>

## v0.1.6 (2017-09-20)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 1 commit contributed to the release.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Remove syntax items we're not checking ([`4d509e6`](https://github.com/JohnTitor/ctest2/commit/4d509e6c1d618c726a30a9cb5a5df5bdbfbfe70a))
</details>

## v0.1.5 (2017-09-19)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 9 commits contributed to the release over the course of 76 calendar days.
 - 88 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Bump dep on gcc ([`ada43df`](https://github.com/JohnTitor/ctest2/commit/ada43df485686af8d88b79234e533ec13c10f41e))
    - Try to ease the Rust compiler's pain ([`4447cfb`](https://github.com/JohnTitor/ctest2/commit/4447cfbc169d9c3c8d30f30ef98a963d77df137f))
    - Add support for unions ([`f4e0e2f`](https://github.com/JohnTitor/ctest2/commit/f4e0e2fba07638afe3903a6b655547effcd888a9))
    - Upgrade syntex_syntax dependency ([`391ac85`](https://github.com/JohnTitor/ctest2/commit/391ac85ba8d855b18d78336cb627f7b14d5cd249))
    - Add support for fixed-size array arguments ([`f574bfb`](https://github.com/JohnTitor/ctest2/commit/f574bfb76096de30597089a1e9b6c8c69f5a6454))
    - Add support for double-arrays in struct fields ([`466d365`](https://github.com/JohnTitor/ctest2/commit/466d365f593ad5d39fa3fac066123370495b0a4a))
    - Support explicit `-> ()` ([`2bcacb0`](https://github.com/JohnTitor/ctest2/commit/2bcacb0d87f072015c72e39aff6b8c82a743e5af))
    - Add support for testing `str` consts ([`9771b45`](https://github.com/JohnTitor/ctest2/commit/9771b45e0ead3fff4187b1674de9dc84d39dbda2))
    - Increase the default recursion limit ([`de371b4`](https://github.com/JohnTitor/ctest2/commit/de371b4fbf7efec032aea375bceed83ad1191b6d))
</details>

## v0.1.4 (2017-06-23)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 5 commits contributed to the release over the course of 15 calendar days.
 - 28 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #19 from sfackler/master ([`08db942`](https://github.com/JohnTitor/ctest2/commit/08db9429293a53c2fa8d39f0cc43a04add955100))
    - Extern blocks can't be public ([`1254f45`](https://github.com/JohnTitor/ctest2/commit/1254f45225d62d6699bd56e40c3d3aaacdd9c2b6))
    - Handle ABIs in fields ([`73b72c1`](https://github.com/JohnTitor/ctest2/commit/73b72c1fa6b07f6da95fb035b1e92f82fc149236))
    - Merge pull request #18 from malbarbo/emscripten ([`f4835aa`](https://github.com/JohnTitor/ctest2/commit/f4835aa2a14411beebc67e9a900858978d03cc92))
    - Add support emscripten targets ([`514a2f2`](https://github.com/JohnTitor/ctest2/commit/514a2f21990d83aa6fb4186a7220bf073558d87d))
</details>

## v0.1.2 (2017-05-25)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 7 commits contributed to the release over the course of 145 calendar days.
 - 189 days passed between releases.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Merge pull request #17 from petrochenkov/master ([`ae0bbf4`](https://github.com/JohnTitor/ctest2/commit/ae0bbf4e89de49b588d251769a5af8adcceb00b4))
    - Bump syntex_syntax to 0.27.0 to fix build on nightly rustc ([`9c81b92`](https://github.com/JohnTitor/ctest2/commit/9c81b927f3e1400f6558a65eeaffa126940ecf8c))
    - Merge pull request #16 from cactorium/master ([`0b7f7b7`](https://github.com/JohnTitor/ctest2/commit/0b7f7b707add9d10c85bd3911030f7a739c349fa))
    - Add -uknown-linux-uclibc as target ([`376f59a`](https://github.com/JohnTitor/ctest2/commit/376f59a67cdae9d0f162f03b25c3b39f138b5eb3))
    - Support cast expressions in array lengths ([`80c0e5d`](https://github.com/JohnTitor/ctest2/commit/80c0e5d8dfa6d95c1b1fd7a313ba08ece18fac2f))
    - Merge pull request #13 from japaric/sparc64 ([`b703b23`](https://github.com/JohnTitor/ctest2/commit/b703b23c69afe0f4939e0c7f6540e40e2f4a12e0))
    - Sparc64 support ([`6d24033`](https://github.com/JohnTitor/ctest2/commit/6d24033d97a8b559245397102a3d751168050672))
</details>

## v0.1.1 (2016-11-16)

### Commit Statistics

<csr-read-only-do-not-edit/>

 - 43 commits contributed to the release over the course of 427 calendar days.
 - 0 commits were understood as [conventional](https://www.conventionalcommits.org).
 - 0 issues like '(#ID)' were seen in commit messages

### Commit Details

<csr-read-only-do-not-edit/>

<details><summary>view details</summary>

 * **Uncategorized**
    - Fix powerpc64le target_arch ([`d5aac51`](https://github.com/JohnTitor/ctest2/commit/d5aac516d895556d652c15134ba1ad6cec5e38be))
    - Merge pull request #10 from japaric/i586 ([`2839e49`](https://github.com/JohnTitor/ctest2/commit/2839e49847a6adca6e96cc81c46a1f03f8562ac0))
    - Add support for i586 targets ([`723f739`](https://github.com/JohnTitor/ctest2/commit/723f73993f5b70e12f48d26ffde1659b2b7dbd7a))
    - Merge pull request #9 from japaric/s390x ([`b7e6a3b`](https://github.com/JohnTitor/ctest2/commit/b7e6a3bca9ffe26b3c026e1255b3d4f0467485b2))
    - Add support for s390x ([`bf56085`](https://github.com/JohnTitor/ctest2/commit/bf560858ef6f199b953d0d7a5568124908742057))
    - Merge pull request #8 from japaric/mips64 ([`f3e6b73`](https://github.com/JohnTitor/ctest2/commit/f3e6b73310165a39cb4f463f3a66d4f98d243ffa))
    - Add support for mips64 ([`9109572`](https://github.com/JohnTitor/ctest2/commit/910957269ba81f096ef60727ed104436557bec85))
    - Merge pull request #7 from polachok/flags ([`a6becb6`](https://github.com/JohnTitor/ctest2/commit/a6becb6d7fd23d9863cba86eac31d1ffc4082734))
    - Allow user-specified flags override default ([`ff477ba`](https://github.com/JohnTitor/ctest2/commit/ff477ba55454af2b9837b9a60ad036912c1d57d2))
    - Add custom flags ([`965d657`](https://github.com/JohnTitor/ctest2/commit/965d6571ef4cfa0a911e89cee11e2f3cb211d6f0))
    - Print out rerun-if-changed keys to properly recompile ([`a2cf6be`](https://github.com/JohnTitor/ctest2/commit/a2cf6bec049efcaaee820631bd652c6fe52dfc1e))
    - Hide a weird API for now ([`c30b0cf`](https://github.com/JohnTitor/ctest2/commit/c30b0cfbc03af606e5a23e4496d0b6940ee1ea7f))
    - Add lots of API docs ([`2a95ee9`](https://github.com/JohnTitor/ctest2/commit/2a95ee9197c0bd3dab9dd95d6d0cd1a03e05bfb7))
    - Revert "Update dependency on syntex_syntax" ([`50ac771`](https://github.com/JohnTitor/ctest2/commit/50ac771acb7bb45cf0c182a5a9c8188a15c89efc))
    - Update dependency on syntex_syntax ([`d0c658d`](https://github.com/JohnTitor/ctest2/commit/d0c658d38d6db8f2a1ff1c5fae38d5a026fcaab2))
    - Revert "Correct test names" ([`7703b51`](https://github.com/JohnTitor/ctest2/commit/7703b51086cce2d9a703b103d0695b36653b8cab))
    - Separate a function for compiling and generating ([`4b8a0cb`](https://github.com/JohnTitor/ctest2/commit/4b8a0cb2907eb006a138fb3d7e0f03eafaf86921))
    - Correct test names ([`2fa4c8b`](https://github.com/JohnTitor/ctest2/commit/2fa4c8b17551af7a4ebd799ca6332ef2cace8213))
    - Merge pull request #4 from antonblanchard/powerpc64_merge ([`903b7f1`](https://github.com/JohnTitor/ctest2/commit/903b7f130e954d8583777255850d433b36f61f00))
    - Add powerpc, powerpc64 and powerpc64le support ([`7058f68`](https://github.com/JohnTitor/ctest2/commit/7058f6898a428589520803b4d1e3d24887698284))
    - Merge pull request #3 from mneumann/dragonfly ([`2a0524d`](https://github.com/JohnTitor/ctest2/commit/2a0524de7542aebdb7d6a2f104780c0bdfaa3b56))
    - Fix for DragonFly ([`ea100e2`](https://github.com/JohnTitor/ctest2/commit/ea100e21377055b7fe4f032d9868c21cf97d06a6))
    - Merge pull request #2 from semarie/openbsd ([`30ccebc`](https://github.com/JohnTitor/ctest2/commit/30ccebc2565e7325a045afa6189e00223471c421))
    - Add openbsd support ([`702791e`](https://github.com/JohnTitor/ctest2/commit/702791e663dbd783d23e9f3e2acc78ae853766d0))
    - Don't use link_name in C by default ([`4b29e7d`](https://github.com/JohnTitor/ctest2/commit/4b29e7d8cf64370a3e38c9a2f31fc577a953689b))
    - Add os detection for netbsd ([`c78f4af`](https://github.com/JohnTitor/ctest2/commit/c78f4af3206d420bac0b88abab8b5d51bf4c8084))
    - Add option to skip an entire struct ([`07fe948`](https://github.com/JohnTitor/ctest2/commit/07fe948a45d7ed665ed0b0405f7d2c4db3140e44))
    - Bump dep on syntex_syntax ([`68c6cd6`](https://github.com/JohnTitor/ctest2/commit/68c6cd690391948b10b5fc02427c52c05272fbc8))
    - Don't test non-public constants ([`ec5cda4`](https://github.com/JohnTitor/ctest2/commit/ec5cda4ba0a0d2a8c991f53a669893fb06df17ca))
    - Detect i386 as well ([`45136e5`](https://github.com/JohnTitor/ctest2/commit/45136e50f5c3c103b3edcb28367f957471a3afe1))
    - Add iOS detection ([`43ba64e`](https://github.com/JohnTitor/ctest2/commit/43ba64e0e188c9e65fcd4b5c2b488eefc1e2a7b2))
    - Add aarch64 detection ([`7d4b14f`](https://github.com/JohnTitor/ctest2/commit/7d4b14fe8000f21176802d07851af4108bcd0fdf))
    - Add the ability to skip fields ([`ff49248`](https://github.com/JohnTitor/ctest2/commit/ff49248fc09ab51bc48ecdbfa5af73735babf341))
    - Support testing constants which are structs ([`a2bea04`](https://github.com/JohnTitor/ctest2/commit/a2bea04e6177dccf53f78ee9bac0f4517f4b9f5f))
    - Ignore a few more windows msvc warnings ([`6ac333e`](https://github.com/JohnTitor/ctest2/commit/6ac333e6e64c4c470a8026dd73d3a59f67845b34))
    - Add skipping a struct field's type ([`4fb81c4`](https://github.com/JohnTitor/ctest2/commit/4fb81c4e62e9a73d43d4e6b1f485a611cfb597ab))
    - Fix fixed-size arrays and function pointers ([`72ed6f6`](https://github.com/JohnTitor/ctest2/commit/72ed6f6efeb40ee25abb7c2d39d5af1fc172c170))
    - Test struct field types ([`8e619cd`](https://github.com/JohnTitor/ctest2/commit/8e619cdace5126c5f216479abdd486975f5167ae))
    - Use FFI safe type ([`dbc5d24`](https://github.com/JohnTitor/ctest2/commit/dbc5d24a724d31ab7f4afdcf47666ea0dc161f32))
    - Add test for all possible error messages ([`3e7a6a9`](https://github.com/JohnTitor/ctest2/commit/3e7a6a949dae934ed62924389f17e791feafae8c))
    - Use __alignof on MSVC ([`63ff2b4`](https://github.com/JohnTitor/ctest2/commit/63ff2b4f37c0ab98639e6b6c3b0cf7ef82d60581))
    - Add an option to skip the pointer check ([`b1d0e03`](https://github.com/JohnTitor/ctest2/commit/b1d0e03b10d7087c0d41b3cb00ac31a0ca471a6b))
    - Initial commit ([`d15487c`](https://github.com/JohnTitor/ctest2/commit/d15487c557d6deb6a05e426da3e2bf11ee5cb936))
</details>

