/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.concurrent.Callable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Fail;
import org.assertj.core.error.ShouldBeInstance;

public class ThrowableAssert<ACTUAL extends Throwable>
extends AbstractThrowableAssert<ThrowableAssert<ACTUAL>, ACTUAL> {
    public ThrowableAssert(ACTUAL actual) {
        super(actual, ThrowableAssert.class);
    }

    public <V> ThrowableAssert(Callable<V> runnable2) {
        super(ThrowableAssert.buildThrowableAssertFromCallable(runnable2), ThrowableAssert.class);
    }

    private static <V, THROWABLE extends Throwable> THROWABLE buildThrowableAssertFromCallable(Callable<V> callable) throws AssertionError {
        try {
            callable.call();
            Fail.fail("Expecting code to throw an exception.");
            return null;
        }
        catch (AssertionError e2) {
            throw e2;
        }
        catch (Throwable throwable) {
            return (THROWABLE)throwable;
        }
    }

    public static Throwable catchThrowable(ThrowingCallable shouldRaiseThrowable) {
        try {
            shouldRaiseThrowable.call();
        }
        catch (Throwable throwable) {
            return throwable;
        }
        return null;
    }

    @Deprecated(since="3", forRemoval=true)
    public static <THROWABLE extends Throwable> THROWABLE catchThrowableOfType(ThrowingCallable shouldRaiseThrowable, Class<THROWABLE> type) {
        return ThrowableAssert.catchThrowableOfType(type, shouldRaiseThrowable);
    }

    public static <THROWABLE extends Throwable> THROWABLE catchThrowableOfType(Class<THROWABLE> type, ThrowingCallable shouldRaiseThrowable) {
        Throwable throwable = ThrowableAssert.catchThrowable(shouldRaiseThrowable);
        if (throwable == null) {
            return null;
        }
        ((ThrowableAssert)new ThrowableAssert<Throwable>(throwable).overridingErrorMessage(ShouldBeInstance.shouldBeInstance(throwable, type).create(), new Object[0])).isInstanceOf((Class)type);
        return (THROWABLE)throwable;
    }

    public static interface ThrowingCallable {
        public void call() throws Throwable;
    }
}

