/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

final class EncryptedDocumentInputStream
extends InputStream {
    private final DocumentInputStream m_dis;
    private final int m_mask;

    public EncryptedDocumentInputStream(DocumentEntry documentEntry, int n) throws IOException {
        this.m_dis = new DocumentInputStream(documentEntry);
        this.m_mask = n;
    }

    @Override
    public int read() throws IOException {
        int n = this.m_dis.read();
        return n ^= this.m_mask;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.m_dis.read(byArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            int n4 = i + n;
            byArray[n4] = (byte)(byArray[n4] ^ this.m_mask);
        }
        return n3;
    }

    @Override
    public int available() {
        return this.m_dis.available();
    }

    @Override
    public void close() {
        this.m_dis.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.m_dis.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.m_dis.markSupported();
    }

    @Override
    public synchronized void reset() {
        this.m_dis.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.m_dis.skip(l);
    }
}

