/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.server.data;

import com.projectlibre1.server.data.IDGenerator;
import com.projectlibre1.server.data.SerializedDataObject;
import com.projectlibre1.server.data.SerializedDataObjectFactory;
import com.projectlibre1.server.data.TaskData;

public class LinkData
extends SerializedDataObject {
    static final long serialVersionUID = 44526718293877L;
    protected TaskData predecessor;
    protected TaskData successor;
    protected long predecessorId = -1L;
    public static final SerializedDataObjectFactory FACTORY = new SerializedDataObjectFactory(){

        @Override
        public SerializedDataObject createSerializedDataObject() {
            return new LinkData();
        }
    };

    public TaskData getPredecessor() {
        return this.predecessor;
    }

    public void setPredecessor(TaskData taskData) {
        this.predecessor = taskData;
        this.setPredecessorId(taskData.getUniqueId());
    }

    public TaskData getSuccessor() {
        return this.successor;
    }

    public void setSuccessor(TaskData taskData) {
        this.successor = taskData;
        this.setSuccessorId(taskData.getUniqueId());
    }

    public long getPredecessorId() {
        return this.predecessorId;
    }

    public void setPredecessorId(long l) {
        this.predecessorId = l;
    }

    public long getSuccessorId() {
        return this.getUniqueId();
    }

    public void setSuccessorId(long l) {
        this.setUniqueId(l);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public void emtpy() {
        this.predecessor = null;
        this.successor = null;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof LinkData) {
            LinkData linkData = (LinkData)object;
            return linkData.getPredecessorId() == this.getPredecessorId();
        }
        return false;
    }

    @Override
    public String toString() {
        return "predId = " + this.getPredecessorId() + ", succId = " + this.getSuccessorId() + ", pred=" + String.valueOf(this.predecessor) + ", succ=" + String.valueOf(this.successor);
    }

    @Override
    public void renumber(IDGenerator iDGenerator) {
        super.renumber(iDGenerator);
        this.setPredecessorId(iDGenerator.getId(this.getPredecessorId()));
    }
}

