/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model;

import java.util.Map;
import java.util.Objects;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.itemencryptor.model.ParsedHeader;

public class DecryptItemOutput {
    private final Map<String, AttributeValue> plaintextItem;
    private final ParsedHeader parsedHeader;

    protected DecryptItemOutput(BuilderImpl builder) {
        this.plaintextItem = builder.plaintextItem();
        this.parsedHeader = builder.parsedHeader();
    }

    public Map<String, AttributeValue> plaintextItem() {
        return this.plaintextItem;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected Map<String, AttributeValue> plaintextItem;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptItemOutput model) {
            this.plaintextItem = model.plaintextItem();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder plaintextItem(Map<String, AttributeValue> plaintextItem) {
            this.plaintextItem = plaintextItem;
            return this;
        }

        @Override
        public Map<String, AttributeValue> plaintextItem() {
            return this.plaintextItem;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public DecryptItemOutput build() {
            if (Objects.isNull(this.plaintextItem())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextItem`");
            }
            return new DecryptItemOutput(this);
        }
    }

    public static interface Builder {
        public Builder plaintextItem(Map<String, AttributeValue> var1);

        public Map<String, AttributeValue> plaintextItem();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public DecryptItemOutput build();
    }
}

