/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.experiment;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.searchrelevance.experiment.EmptyExperimentOptions;
import org.opensearch.searchrelevance.experiment.ExperimentOptions;
import org.opensearch.searchrelevance.experiment.ExperimentOptionsForHybridSearch;

public class ExperimentOptionsFactory {
    public static final String EMPTY_EXPERIMENT_OPTIONS = "EMPTY_EXPERIMENT_OPTIONS";
    public static final String HYBRID_SEARCH_EXPERIMENT_OPTIONS = "HYBRID_SEARCH_EXPERIMENT_OPTIONS";
    private static final Map<String, Function<Map<String, Object>, ExperimentOptions>> OPTIONS_BY_EXPERIMENT_NAME = Map.of("EMPTY_EXPERIMENT_OPTIONS", params -> new EmptyExperimentOptions(), "HYBRID_SEARCH_EXPERIMENT_OPTIONS", ExperimentOptionsFactory::getExperimentOptionsForHybridSearch);

    public static ExperimentOptions createExperimentOptions(String experimentName, Map<String, Object> params) {
        return Optional.ofNullable(OPTIONS_BY_EXPERIMENT_NAME.get(experimentName)).orElseThrow(() -> new IllegalArgumentException("provided experiment name is not supported")).apply(params);
    }

    private static ExperimentOptionsForHybridSearch getExperimentOptionsForHybridSearch(Map<String, Object> params) {
        ExperimentOptionsForHybridSearch.ExperimentOptionsForHybridSearchBuilder builder = ExperimentOptionsForHybridSearch.builder();
        if (params.containsKey("normalizationTechniques")) {
            builder.normalizationTechniques((Set)params.get("normalizationTechniques"));
        }
        if (params.containsKey("combinationTechniques")) {
            builder.combinationTechniques((Set)params.get("combinationTechniques"));
        }
        if (params.containsKey("weightsRange")) {
            Map weightsRangeMap = (Map)params.get("weightsRange");
            ExperimentOptionsForHybridSearch.WeightsRange.WeightsRangeBuilder weightsRangeBuilder = ExperimentOptionsForHybridSearch.WeightsRange.builder();
            if (weightsRangeMap.containsKey("rangeMin")) {
                weightsRangeBuilder.rangeMin(((Number)weightsRangeMap.get("rangeMin")).floatValue());
            }
            if (weightsRangeMap.containsKey("rangeMax")) {
                weightsRangeBuilder.rangeMax(((Number)weightsRangeMap.get("rangeMax")).floatValue());
            }
            if (weightsRangeMap.containsKey("increment")) {
                weightsRangeBuilder.increment(((Number)weightsRangeMap.get("increment")).floatValue());
            }
            builder.weightsRange(weightsRangeBuilder.build());
        }
        return builder.build();
    }

    public static Map<String, Object> createDefaultExperimentParametersForHybridSearch() {
        return Map.of("normalizationTechniques", Set.of("min_max", "l2"), "combinationTechniques", Set.of("arithmetic_mean", "geometric_mean", "harmonic_mean"), "weightsRange", Map.of("rangeMin", 0.0, "rangeMax", 1.0, "increment", 0.1));
    }
}

