/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tribuo.DataSource;
import org.tribuo.Dataset;
import org.tribuo.Example;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.Prediction;
import org.tribuo.evaluation.Evaluation;
import org.tribuo.evaluation.Evaluator;
import org.tribuo.evaluation.metrics.EvaluationMetric;
import org.tribuo.evaluation.metrics.MetricContext;
import org.tribuo.evaluation.metrics.MetricID;
import org.tribuo.provenance.DataProvenance;
import org.tribuo.provenance.EvaluationProvenance;

public abstract class AbstractEvaluator<T extends Output<T>, C extends MetricContext<T>, E extends Evaluation<T>, M extends EvaluationMetric<T, C>>
implements Evaluator<T, E> {
    @Override
    public final E evaluate(Model<T> model, Dataset<T> dataset) {
        OutputFactory<T> factory = dataset.getOutputFactory();
        int i = 0;
        for (Example<T> example : dataset) {
            if (factory.getUnknownOutput().equals(example.getOutput())) {
                throw new IllegalArgumentException("The sentinel Unknown Output was used as a ground truth label in example number " + i);
            }
            ++i;
        }
        List<Prediction<T>> predictions = model.predict(dataset);
        return this.evaluate(model, predictions, (DataProvenance)dataset.getProvenance());
    }

    @Override
    public final E evaluate(Model<T> model, DataSource<T> datasource) {
        OutputFactory<T> factory = datasource.getOutputFactory();
        ArrayList examples = new ArrayList();
        for (Example example : datasource) {
            if (factory.getUnknownOutput().equals(example.getOutput())) {
                throw new IllegalArgumentException("The sentinel Unknown Output was used as a ground truth label in example number " + examples.size());
            }
            examples.add(example);
        }
        List predictions = model.predict(examples);
        return this.evaluate(model, predictions, (DataProvenance)datasource.getProvenance());
    }

    @Override
    public final E evaluate(Model<T> model, List<Prediction<T>> predictions, DataProvenance dataProvenance) {
        EvaluationProvenance provenance = new EvaluationProvenance(model.getProvenance(), dataProvenance);
        C context = this.createContext(model, predictions);
        Set<M> metrics = this.createMetrics(model);
        Map<MetricID<T>, Double> results = this.computeResults(context, metrics);
        return this.createEvaluation(context, results, provenance);
    }

    protected Map<MetricID<T>, Double> computeResults(C ctx, Set<? extends EvaluationMetric<T, C>> metrics) {
        HashMap<MetricID<T>, Double> results = new HashMap<MetricID<T>, Double>();
        for (EvaluationMetric<T, C> metric : metrics) {
            MetricID<T> id = metric.getID();
            double value = metric.compute(ctx);
            results.put(id, value);
        }
        return results;
    }

    protected abstract Set<M> createMetrics(Model<T> var1);

    protected abstract C createContext(Model<T> var1, List<Prediction<T>> var2);

    protected abstract E createEvaluation(C var1, Map<MetricID<T>, Double> var2, EvaluationProvenance var3);
}

