/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.model;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

public class ResourceCreated
implements ToXContentObject,
Writeable {
    private static final Logger logger = LogManager.getLogger(ResourceCreated.class);
    private final Map<String, String> resourceMap;

    public ResourceCreated(String workflowStepName, String workflowStepId, String resourceType, String resourceId) {
        this(Map.ofEntries(Map.entry("workflow_step_name", workflowStepName), Map.entry("workflow_step_id", workflowStepId), Map.entry("resource_type", resourceType), Map.entry("resource_id", resourceId)));
    }

    public ResourceCreated(StreamInput input) throws IOException {
        this(input.readMap(StreamInput::readString, StreamInput::readString));
    }

    private ResourceCreated(Map<String, String> map) {
        this.resourceMap = Map.copyOf(map);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.map(this.resourceMap);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.resourceMap, StreamOutput::writeString, StreamOutput::writeString);
    }

    public String resourceId() {
        return this.resourceMap.get("resource_id");
    }

    public String resourceType() {
        return this.resourceMap.get("resource_type");
    }

    public String workflowStepName() {
        return this.resourceMap.get("workflow_step_name");
    }

    public String workflowStepId() {
        return this.resourceMap.get("workflow_step_id");
    }

    public Map<String, String> resourceMap() {
        return this.resourceMap;
    }

    public static ResourceCreated parse(XContentParser parser) throws IOException {
        return new ResourceCreated(parser.mapStrings());
    }

    public String toString() {
        return "resources_Created [" + String.valueOf(this.resourceMap) + "]";
    }
}

