/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.utils.Util;
import shaded.com.google.common.base.Joiner;

public class ComperableHitResult {
    private final SearchHit hit;
    private final String comperator;
    private boolean isAllNull;
    private final Map<String, Object> flattenMap;

    public ComperableHitResult(SearchHit hit, String[] fieldsOrder, String seperator) {
        this.hit = hit;
        Map hitAsMap = hit.getSourceAsMap();
        this.flattenMap = new HashMap<String, Object>();
        ArrayList<String> results = new ArrayList<String>();
        this.isAllNull = true;
        for (int i = 0; i < fieldsOrder.length; ++i) {
            String field = fieldsOrder[i];
            Object result = Util.deepSearchInMap(hitAsMap, field);
            if (result == null) {
                results.add("");
                continue;
            }
            this.isAllNull = false;
            results.add(result.toString());
            this.flattenMap.put(field, result);
        }
        this.comperator = Joiner.on((String)seperator).join(results);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComperableHitResult that = (ComperableHitResult)o;
        return this.comperator.equals(that.comperator);
    }

    public boolean isAllNull() {
        return this.isAllNull;
    }

    public int hashCode() {
        return this.comperator.hashCode();
    }

    public String getComperator() {
        return this.comperator;
    }

    public Map<String, Object> getFlattenMap() {
        return this.flattenMap;
    }

    public SearchHit getOriginalHit() {
        return this.hit;
    }
}

