/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;
import org.opensearch.securityanalytics.action.ListCorrelationsAction;
import org.opensearch.securityanalytics.action.ListCorrelationsRequest;
import org.opensearch.securityanalytics.action.ListCorrelationsResponse;
import org.opensearch.transport.client.node.NodeClient;

public class RestListCorrelationAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestListCorrelationAction.class);

    public String getName() {
        return "list_correlation_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_security_analytics/correlations"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.ROOT, "%s %s", request.method(), "/_plugins/_security_analytics/correlations"));
        Long defaultTimestamp = System.currentTimeMillis();
        Long startTimestamp = request.paramAsLong("start_timestamp", defaultTimestamp - 300000L);
        Long endTimestamp = request.paramAsLong("end_timestamp", defaultTimestamp.longValue());
        ListCorrelationsRequest correlationsRequest = new ListCorrelationsRequest(startTimestamp, endTimestamp);
        return channel -> client.execute((ActionType)ListCorrelationsAction.INSTANCE, (ActionRequest)correlationsRequest, (ActionListener)new RestListCorrelationResponseListener((RestChannel)channel, request));
    }

    static class RestListCorrelationResponseListener
    extends RestResponseListener<ListCorrelationsResponse> {
        private final RestRequest request;

        RestListCorrelationResponseListener(RestChannel channel, RestRequest request) {
            super(channel);
            this.request = request;
        }

        public RestResponse buildResponse(ListCorrelationsResponse response) throws Exception {
            return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
        }
    }
}

