/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support.clustermanager.info;

import org.opensearch.action.IndicesRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.TransportIndicesResolvingAction;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.action.support.clustermanager.info.ClusterInfoRequest;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.ResolvedIndices;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public abstract class TransportClusterInfoAction<Request extends ClusterInfoRequest<Request>, Response extends ActionResponse>
extends TransportClusterManagerNodeReadAction<Request, Response>
implements TransportIndicesResolvingAction<Request> {
    public TransportClusterInfoAction(String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Writeable.Reader<Request> request, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(actionName, transportService, clusterService, threadPool, actionFilters, request, indexNameExpressionResolver);
        this.localExecuteSupported = true;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.resolveIndices(state, request).namesOfConcreteIndicesAsArray());
    }

    @Override
    protected final void clusterManagerOperation(Request request, ClusterState state, ActionListener<Response> listener) {
        String[] concreteIndices = this.resolveIndices(state, request).namesOfConcreteIndicesAsArray();
        this.doClusterManagerOperation(request, concreteIndices, state, listener);
    }

    @Override
    public ResolvedIndices resolveIndices(Request request) {
        return ResolvedIndices.of(this.resolveIndices(this.clusterService.state(), request));
    }

    private ResolvedIndices.Local.Concrete resolveIndices(ClusterState state, Request request) {
        return this.indexNameExpressionResolver.concreteResolvedIndices(state, (IndicesRequest)request);
    }

    protected abstract void doClusterManagerOperation(Request var1, String[] var2, ClusterState var3, ActionListener<Response> var4);
}

