/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.DataKey;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;

public final class DecryptionMaterials {
    private final DataKey<?> dataKey;
    private final PublicKey trailingSignatureKey;
    private final Map<String, String> encryptionContext;

    private DecryptionMaterials(Builder b) {
        this.dataKey = b.getDataKey();
        this.trailingSignatureKey = b.getTrailingSignatureKey();
        this.encryptionContext = b.getEncryptionContext() != null ? b.getEncryptionContext() : Collections.emptyMap();
    }

    public DataKey<?> getDataKey() {
        return this.dataKey;
    }

    public PublicKey getTrailingSignatureKey() {
        return this.trailingSignatureKey;
    }

    public Map<String, String> getEncryptionContext() {
        return this.encryptionContext;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        private DataKey<?> dataKey;
        private PublicKey trailingSignatureKey;
        private Map<String, String> encryptionContext;

        private Builder(DecryptionMaterials result) {
            this.dataKey = result.getDataKey();
            this.trailingSignatureKey = result.getTrailingSignatureKey();
            this.encryptionContext = result.getEncryptionContext();
        }

        private Builder() {
        }

        public DataKey<?> getDataKey() {
            return this.dataKey;
        }

        public Builder setDataKey(DataKey<?> dataKey) {
            this.dataKey = dataKey;
            return this;
        }

        public PublicKey getTrailingSignatureKey() {
            return this.trailingSignatureKey;
        }

        public Builder setTrailingSignatureKey(PublicKey trailingSignatureKey) {
            this.trailingSignatureKey = trailingSignatureKey;
            return this;
        }

        public Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        public Builder setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        public DecryptionMaterials build() {
            return new DecryptionMaterials(this);
        }
    }
}

