/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexTemplateDataStreamConfiguration;
import org.opensearch.client.opensearch.indices.IndexTemplateSummary;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexTemplate
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexTemplate> {
    @Nullable
    private final Boolean allowAutoCreate;
    @Nonnull
    private final List<String> composedOf;
    @Nullable
    private final IndexTemplateDataStreamConfiguration dataStream;
    @Nonnull
    private final List<String> indexPatterns;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nullable
    private final Long priority;
    @Nullable
    private final IndexTemplateSummary template;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<IndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplate::setupIndexTemplateDeserializer);

    private IndexTemplate(Builder builder) {
        this.allowAutoCreate = builder.allowAutoCreate;
        this.composedOf = ApiTypeHelper.unmodifiable(builder.composedOf);
        this.dataStream = builder.dataStream;
        this.indexPatterns = ApiTypeHelper.unmodifiableRequired(builder.indexPatterns, (Object)this, "indexPatterns");
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.priority = builder.priority;
        this.template = builder.template;
        this.version = builder.version;
    }

    public static IndexTemplate of(Function<Builder, ObjectBuilder<IndexTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    @Nonnull
    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final IndexTemplateDataStreamConfiguration dataStream() {
        return this.dataStream;
    }

    @Nonnull
    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Long priority() {
        return this.priority;
    }

    @Nullable
    public final IndexTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.dataStream != null) {
            generator.writeKey("data_stream");
            this.dataStream.serialize(generator, mapper);
        }
        generator.writeKey("index_patterns");
        generator.writeStartArray();
        for (String string : this.indexPatterns) {
            generator.write(string);
        }
        generator.writeEnd();
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.longValue());
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::dataStream, IndexTemplateDataStreamConfiguration._DESERIALIZER, "data_stream");
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::priority, JsonpDeserializer.longDeserializer(), "priority");
        op.add(Builder::template, IndexTemplateSummary._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowAutoCreate);
        result = 31 * result + Objects.hashCode(this.composedOf);
        result = 31 * result + Objects.hashCode(this.dataStream);
        result = 31 * result + this.indexPatterns.hashCode();
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.priority);
        result = 31 * result + Objects.hashCode(this.template);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplate other = (IndexTemplate)o;
        return Objects.equals(this.allowAutoCreate, other.allowAutoCreate) && Objects.equals(this.composedOf, other.composedOf) && Objects.equals(this.dataStream, other.dataStream) && this.indexPatterns.equals(other.indexPatterns) && Objects.equals(this.meta, other.meta) && Objects.equals(this.priority, other.priority) && Objects.equals(this.template, other.template) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexTemplate> {
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private List<String> composedOf;
        @Nullable
        private IndexTemplateDataStreamConfiguration dataStream;
        private List<String> indexPatterns;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Long priority;
        @Nullable
        private IndexTemplateSummary template;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(IndexTemplate o) {
            this.allowAutoCreate = o.allowAutoCreate;
            this.composedOf = Builder._listCopy(o.composedOf);
            this.dataStream = o.dataStream;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.meta = Builder._mapCopy(o.meta);
            this.priority = o.priority;
            this.template = o.template;
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.allowAutoCreate = o.allowAutoCreate;
            this.composedOf = Builder._listCopy(o.composedOf);
            this.dataStream = o.dataStream;
            this.indexPatterns = Builder._listCopy(o.indexPatterns);
            this.meta = Builder._mapCopy(o.meta);
            this.priority = o.priority;
            this.template = o.template;
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        @Nonnull
        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        @Nonnull
        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        @Nonnull
        public final Builder dataStream(@Nullable IndexTemplateDataStreamConfiguration value) {
            this.dataStream = value;
            return this;
        }

        @Nonnull
        public final Builder dataStream(Function<IndexTemplateDataStreamConfiguration.Builder, ObjectBuilder<IndexTemplateDataStreamConfiguration>> fn) {
            return this.dataStream(fn.apply(new IndexTemplateDataStreamConfiguration.Builder()).build());
        }

        @Nonnull
        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        @Nonnull
        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder priority(@Nullable Long value) {
            this.priority = value;
            return this;
        }

        @Nonnull
        public final Builder template(@Nullable IndexTemplateSummary value) {
            this.template = value;
            return this;
        }

        @Nonnull
        public final Builder template(Function<IndexTemplateSummary.Builder, ObjectBuilder<IndexTemplateSummary>> fn) {
            return this.template(fn.apply(new IndexTemplateSummary.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public IndexTemplate build() {
            this._checkSingleUse();
            return new IndexTemplate(this);
        }
    }
}

