/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cat;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.cat.CatRequestBase;
import org.opensearch.client.opensearch.cat.CountResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class CountRequest
extends CatRequestBase
implements ToCopyableBuilder<Builder, CountRequest> {
    @Nonnull
    private final List<String> index;
    public static final Endpoint<CountRequest, CountResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CountRequest, CountResponse>(request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_cat/count";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat/count/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, CountResponse._DESERIALIZER);

    private CountRequest(Builder builder) {
        super(builder);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
    }

    public static CountRequest of(Function<Builder, ObjectBuilder<CountRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.index);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountRequest other = (CountRequest)o;
        return Objects.equals(this.index, other.index);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CountRequest> {
        @Nullable
        private List<String> index;

        public Builder() {
        }

        private Builder(CountRequest o) {
            super(o);
            this.index = Builder._listCopy(o.index);
        }

        private Builder(Builder o) {
            super(o);
            this.index = Builder._listCopy(o.index);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Override
        @Nonnull
        public CountRequest build() {
            this._checkSingleUse();
            return new CountRequest(this);
        }
    }
}

