/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.response.exceptions.opensearchexception;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.common.breaker.ResponseLimitBreachedException;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.breaker.CircuitBreakingException;
import org.opensearch.protobufs.ErrorCause;
import org.opensearch.protobufs.ObjectMap;
import org.opensearch.protobufs.StringArray;
import org.opensearch.protobufs.StringOrStringArray;
import org.opensearch.script.ScriptException;
import org.opensearch.search.SearchParseException;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.transport.grpc.proto.response.exceptions.CircuitBreakingExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.FailedNodeExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ParsingExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ResponseLimitBreachedExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.ScriptExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.SearchParseExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.SearchPhaseExecutionExceptionProtoUtils;
import org.opensearch.transport.grpc.proto.response.exceptions.TooManyBucketsExceptionProtoUtils;

public class OpenSearchExceptionProtoUtils {
    private OpenSearchExceptionProtoUtils() {
    }

    public static ErrorCause toProto(OpenSearchException exception) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause((Throwable)exception);
        if (ex != exception) {
            return OpenSearchExceptionProtoUtils.generateThrowableProto(ex);
        }
        return OpenSearchExceptionProtoUtils.innerToProto((Throwable)exception, OpenSearchException.getExceptionName((Throwable)exception), exception.getMessage(), exception.getHeaders(), exception.getMetadata(), exception.getCause());
    }

    public static ErrorCause generateThrowableProto(Throwable t) throws IOException {
        if ((t = ExceptionsHelper.unwrapCause((Throwable)t)) instanceof OpenSearchException) {
            OpenSearchException ose = (OpenSearchException)t;
            return OpenSearchExceptionProtoUtils.toProto(ose);
        }
        return OpenSearchExceptionProtoUtils.innerToProto(t, OpenSearchException.getExceptionName((Throwable)t), t.getMessage(), Collections.emptyMap(), Collections.emptyMap(), t.getCause());
    }

    /*
     * WARNING - void declaration
     */
    public static ErrorCause innerToProto(Throwable throwable, String type, String message, Map<String, List<String>> headers, Map<String, List<String>> metadata, Throwable cause) throws IOException {
        Map.Entry<String, StringOrStringArray> protoEntry;
        ErrorCause.Builder errorCauseBuilder = ErrorCause.newBuilder();
        errorCauseBuilder.setType(type);
        if (message != null) {
            errorCauseBuilder.setReason(message);
        }
        ObjectMap.Builder metadataBuilder = ObjectMap.newBuilder();
        for (Map.Entry<String, List<String>> entry : metadata.entrySet()) {
            protoEntry = OpenSearchExceptionProtoUtils.headerToValueProto(entry.getKey().substring("opensearch.".length()), entry.getValue());
            metadataBuilder.putFields((String)protoEntry.getKey(), (ObjectMap.Value)protoEntry.getValue());
        }
        if (throwable instanceof OpenSearchException) {
            OpenSearchException ose = (OpenSearchException)throwable;
            Map<String, ObjectMap.Value> map = OpenSearchExceptionProtoUtils.metadataToProto(ose);
            for (Map.Entry entry : map.entrySet()) {
                metadataBuilder.putFields((String)entry.getKey(), (ObjectMap.Value)entry.getValue());
            }
        }
        if (metadataBuilder.getFieldsCount() > 0) {
            errorCauseBuilder.setMetadata(metadataBuilder.build());
        }
        if (cause != null) {
            errorCauseBuilder.setCausedBy(OpenSearchExceptionProtoUtils.generateThrowableProto(cause));
        }
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                protoEntry = OpenSearchExceptionProtoUtils.headerToProto((String)entry.getKey(), (List)entry.getValue());
                errorCauseBuilder.putHeader(protoEntry.getKey(), protoEntry.getValue());
            }
        }
        errorCauseBuilder.setStackTrace(ExceptionsHelper.stackTrace((Throwable)throwable));
        Throwable[] allSuppressed = throwable.getSuppressed();
        if (allSuppressed.length > 0) {
            void var11_19;
            Throwable[] throwableArray = allSuppressed;
            int n = throwableArray.length;
            boolean bl = false;
            while (var11_19 < n) {
                Throwable suppressed = throwableArray[var11_19];
                errorCauseBuilder.addSuppressed(OpenSearchExceptionProtoUtils.generateThrowableProto(suppressed));
                ++var11_19;
            }
        }
        return errorCauseBuilder.build();
    }

    public static Map.Entry<String, StringOrStringArray> headerToProto(String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return new AbstractMap.SimpleEntry<String, StringOrStringArray>(key, StringOrStringArray.newBuilder().setString(values.get(0)).build());
            }
            StringArray.Builder stringArrayBuilder = StringArray.newBuilder();
            for (String val : values) {
                stringArrayBuilder.addStringArray(val);
            }
            StringOrStringArray stringOrStringArray = StringOrStringArray.newBuilder().setStringArray(stringArrayBuilder.build()).build();
            return new AbstractMap.SimpleEntry<String, StringOrStringArray>(key, stringOrStringArray);
        }
        return null;
    }

    public static Map.Entry<String, ObjectMap.Value> headerToValueProto(String key, List<String> values) throws IOException {
        if (values != null && !values.isEmpty()) {
            if (values.size() == 1) {
                return new AbstractMap.SimpleEntry<String, ObjectMap.Value>(key, ObjectMap.Value.newBuilder().setString(values.get(0)).build());
            }
            ObjectMap.ListValue.Builder listValueBuilder = ObjectMap.ListValue.newBuilder();
            for (String val : values) {
                listValueBuilder.addValue(ObjectMap.Value.newBuilder().setString(val).build());
            }
            return new AbstractMap.SimpleEntry<String, ObjectMap.Value>(key, ObjectMap.Value.newBuilder().setListValue(listValueBuilder).build());
        }
        return null;
    }

    public static Map<String, ObjectMap.Value> metadataToProto(OpenSearchException exception) {
        OpenSearchException openSearchException = exception;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CircuitBreakingException.class, FailedNodeException.class, ParsingException.class, ResponseLimitBreachedException.class, ScriptException.class, SearchParseException.class, SearchPhaseExecutionException.class, MultiBucketConsumerService.TooManyBucketsException.class}, (Object)openSearchException, n)) {
            case 0 -> {
                CircuitBreakingException cbe = (CircuitBreakingException)openSearchException;
                yield CircuitBreakingExceptionProtoUtils.metadataToProto(cbe);
            }
            case 1 -> {
                FailedNodeException fne = (FailedNodeException)openSearchException;
                yield FailedNodeExceptionProtoUtils.metadataToProto(fne);
            }
            case 2 -> {
                ParsingException pe = (ParsingException)openSearchException;
                yield ParsingExceptionProtoUtils.metadataToProto(pe);
            }
            case 3 -> {
                ResponseLimitBreachedException rlbe = (ResponseLimitBreachedException)openSearchException;
                yield ResponseLimitBreachedExceptionProtoUtils.metadataToProto(rlbe);
            }
            case 4 -> {
                ScriptException se = (ScriptException)openSearchException;
                yield ScriptExceptionProtoUtils.metadataToProto(se);
            }
            case 5 -> {
                SearchParseException spe = (SearchParseException)openSearchException;
                yield SearchParseExceptionProtoUtils.metadataToProto(spe);
            }
            case 6 -> {
                SearchPhaseExecutionException spee = (SearchPhaseExecutionException)openSearchException;
                yield SearchPhaseExecutionExceptionProtoUtils.metadataToProto(spee);
            }
            case 7 -> {
                MultiBucketConsumerService.TooManyBucketsException tmbe = (MultiBucketConsumerService.TooManyBucketsException)openSearchException;
                yield TooManyBucketsExceptionProtoUtils.metadataToProto(tmbe);
            }
            default -> new HashMap<String, ObjectMap.Value>();
        };
    }
}

