/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.apache.commons.compress.utils.CountingOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.history.EventLogFileWriter;
import org.apache.spark.deploy.history.EventLogFileWriter$;
import org.apache.spark.deploy.history.RollingEventLogFilesWriter$;
import org.apache.spark.internal.config.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005=h\u0001\u0002\u0017.\u0001aB\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!q\u0006A!A!\u0002\u0013y\u0006\"B4\u0001\t\u0003A\u0007bB8\u0001\u0005\u0004%I\u0001\u001d\u0005\u0007i\u0002\u0001\u000b\u0011B9\t\u000fU\u0004!\u0019!C\u0005m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001A\u0002\u0013%q\u0010C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\u001a!A\u0011Q\u0005\u0001!B\u0013\t\t\u0001\u0003\u0005\u0002(\u0001\u0001\r\u0011\"\u0003q\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003C\u0004\u00020\u0001\u0001\u000b\u0015B9\t\u0015\u0005E\u0002\u00011AA\u0002\u0013%a\u000fC\u0006\u00024\u0001\u0001\r\u00111A\u0005\n\u0005U\u0002BCA\u001d\u0001\u0001\u0007\t\u0011)Q\u0005o\"9\u00111\b\u0001\u0005B\u0005u\u0002bBA \u0001\u0011\u0005\u0013\u0011\t\u0005\n\u0003#\u0002\u0011\u0013!C\u0001\u0003'B\u0001\"!\u001b\u0001\t\u0003i\u0013Q\b\u0005\b\u0003W\u0002A\u0011IA\u001f\u0011\u001d\ti\u0007\u0001C!\u0003_Bq!!\u001d\u0001\t\u0013\t\u0019hB\u0004\u0002z5B\t!a\u001f\u0007\r1j\u0003\u0012AA?\u0011\u00199G\u0004\"\u0001\u0002\u0006\"Q\u0011q\u0011\u000fC\u0002\u0013\u0005Q&!#\t\u0011\u0005UE\u0004)A\u0005\u0003\u0017C!\"a&\u001d\u0005\u0004%\t!LAE\u0011!\tI\n\bQ\u0001\n\u0005-\u0005BCAN9\t\u0007I\u0011A\u0017\u0002\n\"A\u0011Q\u0014\u000f!\u0002\u0013\tY\tC\u0004\u0002 r!\t!!)\t\u000f\u0005%F\u0004\"\u0001\u0002,\"9\u0011q\u0017\u000f\u0005\u0002\u0005e\u0006bBAd9\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003+dB\u0011AAl\u0011\u001d\t)\u000e\bC\u0001\u0003;Dq!!9\u001d\t\u0003\t\u0019\u000fC\u0004\u0002hr!\t!!;\u00035I{G\u000e\\5oO\u00163XM\u001c;M_\u001e4\u0015\u000e\\3t/JLG/\u001a:\u000b\u00059z\u0013a\u00025jgR|'/\u001f\u0006\u0003aE\na\u0001Z3qY>L(B\u0001\u001a4\u0003\u0015\u0019\b/\u0019:l\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u000f\t\u0003umj\u0011!L\u0005\u0003y5\u0012!#\u0012<f]Rdun\u001a$jY\u0016<&/\u001b;fe\u0006)\u0011\r\u001d9JIB\u0011q\b\u0013\b\u0003\u0001\u001a\u0003\"!\u0011#\u000e\u0003\tS!aQ\u001c\u0002\rq\u0012xn\u001c;?\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d#\u0015\u0001D1qa\u0006#H/Z7qi&#\u0007cA'O}5\tA)\u0003\u0002P\t\n1q\n\u001d;j_:\f!\u0002\\8h\u0005\u0006\u001cX\rR5s!\t\u0011v+D\u0001T\u0015\t!V+A\u0002oKRT\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n\u0019QKU%\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA.]\u001b\u0005\t\u0014BA/2\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t\r|gN\u001a\u0006\u0003IN\na\u0001[1e_>\u0004\u0018B\u00014b\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"b!\u001b6lY6t\u0007C\u0001\u001e\u0001\u0011\u0015id\u00011\u0001?\u0011\u0015Ye\u00011\u0001M\u0011\u0015\u0001f\u00011\u0001R\u0011\u0015If\u00011\u0001[\u0011\u0015qf\u00011\u0001`\u0003I)g/\u001a8u\r&dW-T1y\u0019\u0016tw\r\u001e5\u0016\u0003E\u0004\"!\u0014:\n\u0005M$%\u0001\u0002'p]\u001e\f1#\u001a<f]R4\u0015\u000e\\3NCbdUM\\4uQ\u0002\n\u0001\u0003\\8h\t&\u0014hi\u001c:BaB\u0004\u0016\r\u001e5\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A_2\u0002\u0005\u0019\u001c\u0018B\u0001?z\u0005\u0011\u0001\u0016\r\u001e5\u0002#1|w\rR5s\r>\u0014\u0018\t\u001d9QCRD\u0007%\u0001\u000bd_VtG/\u001b8h\u001fV$\b/\u001e;TiJ,\u0017-\\\u000b\u0003\u0003\u0003\u0001B!\u0014(\u0002\u0004A!\u0011QAA\n\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!B;uS2\u001c(\u0002BA\u0007\u0003\u001f\t\u0001bY8naJ,7o\u001d\u0006\u0004\u0003#\u0019\u0014aB2p[6|gn]\u0005\u0005\u0003+\t9A\u0001\u000bD_VtG/\u001b8h\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0019G>,h\u000e^5oO>+H\u000f];u'R\u0014X-Y7`I\u0015\fH\u0003BA\u000e\u0003C\u00012!TA\u000f\u0013\r\ty\u0002\u0012\u0002\u0005+:LG\u000fC\u0005\u0002$1\t\t\u00111\u0001\u0002\u0002\u0005\u0019\u0001\u0010J\u0019\u0002+\r|WO\u001c;j]\u001e|U\u000f\u001e9viN#(/Z1nA\u0005)\u0011N\u001c3fq\u0006I\u0011N\u001c3fq~#S-\u001d\u000b\u0005\u00037\ti\u0003\u0003\u0005\u0002$=\t\t\u00111\u0001r\u0003\u0019Ig\u000eZ3yA\u000592-\u001e:sK:$XI^3oi2{wMR5mKB\u000bG\u000f[\u0001\u001cGV\u0014(/\u001a8u\u000bZ,g\u000e\u001e'pO\u001aKG.\u001a)bi\"|F%Z9\u0015\t\u0005m\u0011q\u0007\u0005\t\u0003G\u0011\u0012\u0011!a\u0001o\u0006A2-\u001e:sK:$XI^3oi2{wMR5mKB\u000bG\u000f\u001b\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005m\u0011AC<sSR,WI^3oiR1\u00111DA\"\u0003\u000fBa!!\u0012\u0016\u0001\u0004q\u0014!C3wK:$(j]8o\u0011%\tI%\u0006I\u0001\u0002\u0004\tY%A\u0006gYV\u001c\b\u000eT8hO\u0016\u0014\bcA'\u0002N%\u0019\u0011q\n#\u0003\u000f\t{w\u000e\\3b]\u0006!rO]5uK\u00163XM\u001c;%I\u00164\u0017-\u001e7uII*\"!!\u0016+\t\u0005-\u0013qK\u0016\u0003\u00033\u0002B!a\u0017\u0002f5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0005v]\u000eDWmY6fI*\u0019\u00111\r#\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002h\u0005u#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001\"o\u001c7m\u000bZ,g\u000e\u001e'pO\u001aKG.Z\u0001\u0005gR|\u0007/A\u0004m_\u001e\u0004\u0016\r\u001e5\u0016\u0003y\n1c\u0019:fCR,\u0017\t\u001d9Ti\u0006$Xo\u001d$jY\u0016$B!a\u0007\u0002v!9\u0011q\u000f\u000eA\u0002\u0005-\u0013AC5o!J|wM]3tg\u0006Q\"k\u001c7mS:<WI^3oi2{wMR5mKN<&/\u001b;feB\u0011!\bH\n\u00049\u0005}\u0004cA'\u0002\u0002&\u0019\u00111\u0011#\u0003\r\u0005s\u0017PU3g)\t\tY(A\rF-\u0016sEk\u0018'P\u000f~#\u0015JU0O\u00036+u\f\u0015*F\r&CVCAAF!\u0011\ti)a%\u000e\u0005\u0005=%bAAI+\u0006!A.\u00198h\u0013\rI\u0015qR\u0001\u001b\u000bZ+e\nV0M\u001f\u001e{F)\u0013*`\u001d\u0006kUi\u0018)S\u000b\u001aK\u0005\fI\u0001\u001b\u000bZ+e\nV0M\u001f\u001e{f)\u0013'F?:\u000bU*R0Q%\u00163\u0015\nW\u0001\u001c\u000bZ+e\nV0M\u001f\u001e{f)\u0013'F?:\u000bU*R0Q%\u00163\u0015\n\u0017\u0011\u00025\u0005\u0003\u0006k\u0015+B)V\u001bvLR%M\u000b~s\u0015)T#`!J+e)\u0013-\u00027\u0005\u0003\u0006k\u0015+B)V\u001bvLR%M\u000b~s\u0015)T#`!J+e)\u0013-!\u0003U9W\r^!qa\u00163XM\u001c;M_\u001e$\u0015N\u001d)bi\"$ra^AR\u0003K\u000b9\u000bC\u0003QI\u0001\u0007\u0011\u000bC\u0003>I\u0001\u0007a\bC\u0003LI\u0001\u0007A*\u0001\u000bhKR\f\u0005\u000f]*uCR,8OR5mKB\u000bG\u000f\u001b\u000b\no\u00065\u0016\u0011WAZ\u0003kCa!a,&\u0001\u00049\u0018!C1qa2{w\rR5s\u0011\u0015iT\u00051\u0001?\u0011\u0015YU\u00051\u0001M\u0011\u001d\t9(\na\u0001\u0003\u0017\n1cZ3u\u000bZ,g\u000e\u001e'pO\u001aKG.\u001a)bi\"$2b^A^\u0003{\u000by,!1\u0002D\"1\u0011q\u0016\u0014A\u0002]DQ!\u0010\u0014A\u0002yBQa\u0013\u0014A\u00021Ca!a\n'\u0001\u0004\t\bBBAcM\u0001\u0007A*A\u0005d_\u0012,7MT1nK\u0006i\u0011n]#wK:$Hj\\4ESJ$B!a\u0013\u0002L\"9\u0011QZ\u0014A\u0002\u0005=\u0017AB:uCR,8\u000fE\u0002y\u0003#L1!a5z\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u000fSN,e/\u001a8u\u0019><g)\u001b7f)\u0011\tY%!7\t\r\u0005m\u0007\u00061\u0001?\u0003!1\u0017\u000e\\3OC6,G\u0003BA&\u0003?Dq!!4*\u0001\u0004\ty-A\bjg\u0006\u0003\bo\u0015;biV\u001ch)\u001b7f)\u0011\tY%!:\t\u000f\u00055'\u00061\u0001\u0002P\u0006!r-\u001a;Fm\u0016tG\u000fT8h\r&dW-\u00138eKb$2!]Av\u0011\u0019\tio\u000ba\u0001}\u0005\u0001RM^3oi2{wMR5mK:\u000bW.\u001a")
public class RollingEventLogFilesWriter
extends EventLogFileWriter {
    private final String appId;
    private final Option<String> appAttemptId;
    private final long eventFileMaxLength;
    private final Path logDirForAppPath;
    private Option<CountingOutputStream> countingOutputStream;
    private long index;
    private Path currentEventLogFilePath;

    public static long getEventLogFileIndex(String eventLogFileName) {
        return RollingEventLogFilesWriter$.MODULE$.getEventLogFileIndex(eventLogFileName);
    }

    public static boolean isAppStatusFile(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isAppStatusFile(status);
    }

    public static boolean isEventLogFile(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogFile(status);
    }

    public static boolean isEventLogFile(String fileName) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogFile(fileName);
    }

    public static boolean isEventLogDir(FileStatus status) {
        return RollingEventLogFilesWriter$.MODULE$.isEventLogDir(status);
    }

    public static Path getEventLogFilePath(Path appLogDir, String appId, Option<String> appAttemptId, long index, Option<String> codecName) {
        return RollingEventLogFilesWriter$.MODULE$.getEventLogFilePath(appLogDir, appId, appAttemptId, index, codecName);
    }

    public static Path getAppStatusFilePath(Path appLogDir, String appId, Option<String> appAttemptId, boolean inProgress) {
        return RollingEventLogFilesWriter$.MODULE$.getAppStatusFilePath(appLogDir, appId, appAttemptId, inProgress);
    }

    public static Path getAppEventLogDirPath(URI logBaseDir, String appId, Option<String> appAttemptId) {
        return RollingEventLogFilesWriter$.MODULE$.getAppEventLogDirPath(logBaseDir, appId, appAttemptId);
    }

    private long eventFileMaxLength() {
        return this.eventFileMaxLength;
    }

    private Path logDirForAppPath() {
        return this.logDirForAppPath;
    }

    private Option<CountingOutputStream> countingOutputStream() {
        return this.countingOutputStream;
    }

    private void countingOutputStream_$eq(Option<CountingOutputStream> x$1) {
        this.countingOutputStream = x$1;
    }

    private long index() {
        return this.index;
    }

    private void index_$eq(long x$1) {
        this.index = x$1;
    }

    private Path currentEventLogFilePath() {
        return this.currentEventLogFilePath;
    }

    private void currentEventLogFilePath_$eq(Path x$1) {
        this.currentEventLogFilePath = x$1;
    }

    @Override
    public void start() {
        this.requireLogBaseDirAsDirectory();
        Object object = this.fileSystem().exists(this.logDirForAppPath()) && this.shouldOverwrite() ? BoxesRunTime.boxToBoolean((boolean)this.fileSystem().delete(this.logDirForAppPath(), true)) : BoxedUnit.UNIT;
        if (this.fileSystem().exists(this.logDirForAppPath())) {
            throw new IOException(new StringBuilder(38).append("Target log directory already exists (").append(this.logDirForAppPath()).append(")").toString());
        }
        FileSystem.mkdirs((FileSystem)this.fileSystem(), (Path)this.logDirForAppPath(), (FsPermission)EventLogFileWriter$.MODULE$.LOG_FOLDER_PERMISSIONS());
        this.createAppStatusFile(true);
        this.rollEventLogFile();
    }

    @Override
    public void writeEvent(String eventJson, boolean flushLogger) {
        this.writer().foreach((Function1 & Serializable)w -> {
            RollingEventLogFilesWriter.$anonfun$writeEvent$1(this, eventJson, w);
            return BoxedUnit.UNIT;
        });
        this.writeLine(eventJson, flushLogger);
    }

    @Override
    public boolean writeEvent$default$2() {
        return false;
    }

    public void rollEventLogFile() {
        this.closeWriter();
        this.index_$eq(this.index() + 1L);
        this.currentEventLogFilePath_$eq(RollingEventLogFilesWriter$.MODULE$.getEventLogFilePath(this.logDirForAppPath(), this.appId, this.appAttemptId, this.index(), this.compressionCodecName()));
        this.initLogFile(this.currentEventLogFilePath(), (Function1<OutputStream, PrintWriter>)(Function1 & Serializable)os -> {
            this.countingOutputStream_$eq((Option<CountingOutputStream>)new Some((Object)new CountingOutputStream(os)));
            return new PrintWriter(new OutputStreamWriter((OutputStream)this.countingOutputStream().get(), StandardCharsets.UTF_8));
        });
    }

    @Override
    public void stop() {
        this.closeWriter();
        Path appStatusPathIncomplete = RollingEventLogFilesWriter$.MODULE$.getAppStatusFilePath(this.logDirForAppPath(), this.appId, this.appAttemptId, true);
        Path appStatusPathComplete = RollingEventLogFilesWriter$.MODULE$.getAppStatusFilePath(this.logDirForAppPath(), this.appId, this.appAttemptId, false);
        this.renameFile(appStatusPathIncomplete, appStatusPathComplete, true);
    }

    @Override
    public String logPath() {
        return this.logDirForAppPath().toString();
    }

    private void createAppStatusFile(boolean inProgress) {
        Path appStatusPath = RollingEventLogFilesWriter$.MODULE$.getAppStatusFilePath(this.logDirForAppPath(), this.appId, this.appAttemptId, inProgress);
        FSDataOutputStream outputStream = FileSystem.create((FileSystem)this.fileSystem(), (Path)appStatusPath, (FsPermission)EventLogFileWriter$.MODULE$.LOG_FILE_PERMISSIONS());
        outputStream.close();
    }

    public static final /* synthetic */ void $anonfun$writeEvent$1(RollingEventLogFilesWriter $this, String eventJson$1, PrintWriter w) {
        block0: {
            long currentLen = ((CountingOutputStream)$this.countingOutputStream().get()).getBytesWritten();
            if (currentLen + (long)eventJson$1.length() <= $this.eventFileMaxLength()) break block0;
            $this.rollEventLogFile();
        }
    }

    public RollingEventLogFilesWriter(String appId, Option<String> appAttemptId, URI logBaseDir, SparkConf sparkConf, Configuration hadoopConf) {
        this.appId = appId;
        this.appAttemptId = appAttemptId;
        super(appId, appAttemptId, logBaseDir, sparkConf, hadoopConf);
        this.eventFileMaxLength = BoxesRunTime.unboxToLong((Object)sparkConf.get(package$.MODULE$.EVENT_LOG_ROLLING_MAX_FILE_SIZE()));
        this.logDirForAppPath = RollingEventLogFilesWriter$.MODULE$.getAppEventLogDirPath(logBaseDir, appId, appAttemptId);
        this.countingOutputStream = None$.MODULE$;
        this.index = 0L;
    }
}

