/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.summarization;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.returntypes.SampleSummary;
import com.amazon.randomcutforest.summarization.Center;
import com.amazon.randomcutforest.summarization.ICluster;
import com.amazon.randomcutforest.summarization.IPointIndexCluster;
import com.amazon.randomcutforest.util.Weighted;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;

public class Summarizer {
    public static double WEIGHT_ALLOCATION_THRESHOLD = 1.25;
    public static double SEPARATION_RATIO_FOR_MERGE = 0.8;
    public static int PHASE2_THRESHOLD = 2;
    public static int LENGTH_BOUND = 1000;

    public static Double L1distance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dist += (double)Math.abs(a[i] - b[i]);
        }
        return dist;
    }

    public static Double L2distance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double t = Math.abs(a[i] - b[i]);
            dist += t * t;
        }
        return Math.sqrt(dist);
    }

    public static Double LInfinitydistance(float[] a, float[] b) {
        double dist = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dist = Math.max((double)Math.abs(a[i] - b[i]), dist);
        }
        return dist;
    }

    public static void assignAndRecompute(List<Weighted<float[]>> sampledPoints, ArrayList<IPointIndexCluster> clusters, BiFunction<float[], float[], Double> distance, boolean parallelEnabled) {
        CommonUtils.checkArgument(clusters.size() > 0, " cannot be empty list of clusters");
        CommonUtils.checkArgument(sampledPoints.size() > 0, " cannot be empty list of points");
        for (IPointIndexCluster cluster : clusters) {
            cluster.reset();
        }
        int counter = 0;
        for (Weighted<float[]> point : sampledPoints) {
            if (point.weight > 0.0f) {
                double[] dist = new double[clusters.size()];
                Arrays.fill(dist, Double.MAX_VALUE);
                double minDist = Double.MAX_VALUE;
                int minDistNbr = -1;
                for (int i = 0; i < clusters.size(); ++i) {
                    dist[i] = clusters.get(i).distance((float[])point.index, distance);
                    if (minDist > dist[i]) {
                        minDist = dist[i];
                        minDistNbr = i;
                    }
                    if (minDist == 0.0) break;
                }
                if (minDist == 0.0) {
                    clusters.get(minDistNbr).addPoint(counter, point.weight, 0.0);
                } else {
                    int i;
                    double sum = 0.0;
                    for (i = 0; i < clusters.size(); ++i) {
                        if (!(dist[i] <= WEIGHT_ALLOCATION_THRESHOLD * minDist)) continue;
                        sum += minDist / dist[i];
                    }
                    for (i = 0; i < clusters.size(); ++i) {
                        if (!(dist[i] <= WEIGHT_ALLOCATION_THRESHOLD * minDist)) continue;
                        clusters.get(i).addPoint(counter, (float)((double)point.weight * minDist / (dist[i] * sum)), dist[i]);
                    }
                }
            }
            ++counter;
        }
        if (parallelEnabled) {
            clusters.parallelStream().forEach(e -> e.recompute(sampledPoints, distance));
        } else {
            clusters.stream().forEach(e -> e.recompute(sampledPoints, distance));
        }
    }

    public static <Q extends IPointIndexCluster> List<IPointIndexCluster> iterativeClustering(int maxAllowed, int initial, List<Weighted<float[]>> sampledPoints, BiFunction<float[], float[], Double> distance, BiFunction<float[], Float, Q> clusterInitializer, long seed, boolean parallelEnabled, boolean phase1reassign, boolean enablePhase3, double overlapParameter) {
        boolean keepReducingCenters;
        CommonUtils.checkArgument(sampledPoints.size() > 0, "empty list, nothing to do");
        double sampledSum = sampledPoints.stream().map(e -> e.weight).reduce(Double::sum).get();
        Random rng = new Random(seed);
        ArrayList<IPointIndexCluster> centers = new ArrayList<IPointIndexCluster>();
        if (sampledPoints.size() < 10 * initial) {
            for (Weighted<float[]> point : sampledPoints) {
                centers.add((IPointIndexCluster)clusterInitializer.apply((float[])point.index, Float.valueOf(point.weight)));
            }
        } else {
            for (int k = 0; k < 2 * initial; ++k) {
                double wt = rng.nextDouble() * sampledSum;
                Weighted picked = Weighted.prefixPick(sampledPoints, wt);
                centers.add((IPointIndexCluster)clusterInitializer.apply((float[])picked.index, Float.valueOf(picked.weight)));
            }
        }
        Summarizer.assignAndRecompute(sampledPoints, centers, distance, parallelEnabled);
        centers.sort(Comparator.comparingDouble(ICluster::getWeight));
        while (centers.get(0).getWeight() == 0.0) {
            centers.remove(0);
        }
        double phase3Distance = 0.0;
        boolean bl = keepReducingCenters = centers.size() > maxAllowed;
        while (keepReducingCenters) {
            int lower;
            double measure = 0.0;
            double measureDist = Double.MAX_VALUE;
            int firstOfMerge = lower = 0;
            int secondOfMerge = lower + 1;
            boolean foundMerge = false;
            double minDist = Double.MAX_VALUE;
            while (lower < centers.size() - 1 && !foundMerge) {
                int minNbr = -1;
                for (int j = lower + 1; j < centers.size(); ++j) {
                    double temp;
                    double dist = centers.get(lower).distance(centers.get(j), distance);
                    if (dist == 0.0) {
                        foundMerge = true;
                        firstOfMerge = lower;
                        secondOfMerge = minNbr = j;
                        measureDist = 0.0;
                        minDist = 0.0;
                        break;
                    }
                    if (minDist > dist) {
                        minNbr = j;
                        minDist = dist;
                    }
                    if (!((temp = (centers.get(lower).averageRadius() + centers.get(j).averageRadius() + phase3Distance) / dist) > overlapParameter) || !(measure < temp)) continue;
                    firstOfMerge = lower;
                    secondOfMerge = j;
                    measure = temp;
                    measureDist = dist;
                }
                if (lower == 0 && !foundMerge) {
                    measureDist = minDist;
                    secondOfMerge = minNbr;
                }
                ++lower;
            }
            int inital = centers.size();
            if (inital > maxAllowed || foundMerge || enablePhase3 && measure > overlapParameter) {
                centers.get(secondOfMerge).absorb(centers.get(firstOfMerge), distance);
                centers.remove(firstOfMerge);
                if (phase1reassign || centers.size() <= PHASE2_THRESHOLD * maxAllowed) {
                    Summarizer.assignAndRecompute(sampledPoints, centers, distance, parallelEnabled);
                }
                centers.sort(Comparator.comparingDouble(ICluster::getWeight));
                while (centers.get(0).getWeight() == 0.0) {
                    centers.remove(0);
                }
                if (inital <= maxAllowed || centers.size() > maxAllowed) continue;
                phase3Distance = measureDist;
                continue;
            }
            keepReducingCenters = false;
        }
        return centers;
    }

    public static SampleSummary summarize(List<Weighted<float[]>> points, int maxAllowed, int initial, boolean phase1reassign, BiFunction<float[], float[], Double> distance, long seed, boolean parallelEnabled) {
        CommonUtils.checkArgument(maxAllowed < 100, "are you sure you want more elements in the summary?");
        CommonUtils.checkArgument(maxAllowed <= initial, "initial parameter should be at least maximum allowed in final result");
        double totalWeight = points.stream().map(e -> e.weight).reduce(0.0, Double::sum);
        CommonUtils.checkArgument(!Double.isNaN(totalWeight) && Double.isFinite(totalWeight), " weights have to finite and non-NaN");
        Random rng = new Random(seed);
        List<Weighted<float[]>> sampledPoints = Weighted.createSample(points, rng.nextLong(), 5 * LENGTH_BOUND, 0.005, 1.0);
        List<IPointIndexCluster> centers = Summarizer.iterativeClustering(maxAllowed, initial, sampledPoints, distance, Center::initialize, rng.nextLong(), parallelEnabled, phase1reassign, true, SEPARATION_RATIO_FOR_MERGE);
        centers.sort((o1, o2) -> Double.compare(o2.getWeight(), o1.getWeight()));
        float[][] pointList = new float[centers.size()][];
        float[] likelihood = new float[centers.size()];
        int dimensions = centers.get(0).primaryRepresentative(distance).length;
        for (int i = 0; i < centers.size(); ++i) {
            pointList[i] = Arrays.copyOf(centers.get(i).primaryRepresentative(distance), dimensions);
            likelihood[i] = (float)(centers.get(i).getWeight() / totalWeight);
        }
        return new SampleSummary(sampledPoints, pointList, likelihood);
    }

    public static SampleSummary summarize(float[][] points, int maxAllowed, int initial, boolean reassignPerStep, BiFunction<float[], float[], Double> distance, long seed, Boolean parallelEnabled) {
        ArrayList<Weighted<float[]>> weighted = new ArrayList<Weighted<float[]>>();
        for (float[] point : points) {
            weighted.add(new Weighted<float[]>(point, 1.0f));
        }
        return Summarizer.summarize(weighted, maxAllowed, initial, reassignPerStep, distance, seed, (boolean)parallelEnabled);
    }

    public static SampleSummary summarize(List<Weighted<float[]>> points, int maxAllowed, int initial, boolean reassignPerStep) {
        return Summarizer.summarize(points, maxAllowed, initial, reassignPerStep, Summarizer::L2distance, new Random().nextLong(), false);
    }

    public static SampleSummary summarize(float[][] points, int maxAllowed) {
        return Summarizer.summarize(points, maxAllowed, 4 * maxAllowed, false, Summarizer::L2distance, new Random().nextLong(), (Boolean)false);
    }
}

