/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.model;

import java.util.Objects;
import software.amazon.cryptography.keystore.model.Discovery;
import software.amazon.cryptography.keystore.model.MRDiscovery;

public class KMSConfiguration {
    private final String kmsKeyArn;
    private final String kmsMRKeyArn;
    private final Discovery discovery;
    private final MRDiscovery mrDiscovery;

    protected KMSConfiguration(BuilderImpl builder) {
        this.kmsKeyArn = builder.kmsKeyArn();
        this.kmsMRKeyArn = builder.kmsMRKeyArn();
        this.discovery = builder.discovery();
        this.mrDiscovery = builder.mrDiscovery();
    }

    public String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public String kmsMRKeyArn() {
        return this.kmsMRKeyArn;
    }

    public Discovery discovery() {
        return this.discovery;
    }

    public MRDiscovery mrDiscovery() {
        return this.mrDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String kmsKeyArn;
        protected String kmsMRKeyArn;
        protected Discovery discovery;
        protected MRDiscovery mrDiscovery;

        protected BuilderImpl() {
        }

        protected BuilderImpl(KMSConfiguration model) {
            this.kmsKeyArn = model.kmsKeyArn();
            this.kmsMRKeyArn = model.kmsMRKeyArn();
            this.discovery = model.discovery();
            this.mrDiscovery = model.mrDiscovery();
        }

        @Override
        public Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public String kmsKeyArn() {
            return this.kmsKeyArn;
        }

        @Override
        public Builder kmsMRKeyArn(String kmsMRKeyArn) {
            this.kmsMRKeyArn = kmsMRKeyArn;
            return this;
        }

        @Override
        public String kmsMRKeyArn() {
            return this.kmsMRKeyArn;
        }

        @Override
        public Builder discovery(Discovery discovery) {
            this.discovery = discovery;
            return this;
        }

        @Override
        public Discovery discovery() {
            return this.discovery;
        }

        @Override
        public Builder mrDiscovery(MRDiscovery mrDiscovery) {
            this.mrDiscovery = mrDiscovery;
            return this;
        }

        @Override
        public MRDiscovery mrDiscovery() {
            return this.mrDiscovery;
        }

        @Override
        public KMSConfiguration build() {
            if (Objects.nonNull(this.kmsKeyArn()) && this.kmsKeyArn().length() < 1) {
                throw new IllegalArgumentException("The size of `kmsKeyArn` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.kmsKeyArn()) && this.kmsKeyArn().length() > 2048) {
                throw new IllegalArgumentException("The size of `kmsKeyArn` must be less than or equal to 2048");
            }
            if (Objects.nonNull(this.kmsMRKeyArn()) && this.kmsMRKeyArn().length() < 1) {
                throw new IllegalArgumentException("The size of `kmsMRKeyArn` must be greater than or equal to 1");
            }
            if (Objects.nonNull(this.kmsMRKeyArn()) && this.kmsMRKeyArn().length() > 2048) {
                throw new IllegalArgumentException("The size of `kmsMRKeyArn` must be less than or equal to 2048");
            }
            if (!this.onlyOneNonNull()) {
                throw new IllegalArgumentException("`KMSConfiguration` is a Union. A Union MUST have one and only one value set.");
            }
            return new KMSConfiguration(this);
        }

        private boolean onlyOneNonNull() {
            Object[] allValues = new Object[]{this.kmsKeyArn, this.kmsMRKeyArn, this.discovery, this.mrDiscovery};
            boolean haveOneNonNull = false;
            for (Object o : allValues) {
                if (!Objects.nonNull(o)) continue;
                if (haveOneNonNull) {
                    return false;
                }
                haveOneNonNull = true;
            }
            return haveOneNonNull;
        }
    }

    public static interface Builder {
        public Builder kmsKeyArn(String var1);

        public String kmsKeyArn();

        public Builder kmsMRKeyArn(String var1);

        public String kmsMRKeyArn();

        public Builder discovery(Discovery var1);

        public Discovery discovery();

        public Builder mrDiscovery(MRDiscovery var1);

        public MRDiscovery mrDiscovery();

        public KMSConfiguration build();
    }
}

